package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLogstashSettings invokes the elasticsearch.UpdateLogstashSettings API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatelogstashsettings.html
func (client *Client) UpdateLogstashSettings(request *UpdateLogstashSettingsRequest) (response *UpdateLogstashSettingsResponse, err error) {
	response = CreateUpdateLogstashSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLogstashSettingsWithChan invokes the elasticsearch.UpdateLogstashSettings API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatelogstashsettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateLogstashSettingsWithChan(request *UpdateLogstashSettingsRequest) (<-chan *UpdateLogstashSettingsResponse, <-chan error) {
	responseChan := make(chan *UpdateLogstashSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLogstashSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLogstashSettingsWithCallback invokes the elasticsearch.UpdateLogstashSettings API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/updatelogstashsettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateLogstashSettingsWithCallback(request *UpdateLogstashSettingsRequest, callback func(response *UpdateLogstashSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLogstashSettingsResponse
		var err error
		defer close(result)
		response, err = client.UpdateLogstashSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLogstashSettingsRequest is the request struct for api UpdateLogstashSettings
type UpdateLogstashSettingsRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// UpdateLogstashSettingsResponse is the response struct for api UpdateLogstashSettings
type UpdateLogstashSettingsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLogstashSettingsRequest creates a request to invoke UpdateLogstashSettings API
func CreateUpdateLogstashSettingsRequest() (request *UpdateLogstashSettingsRequest) {
	request = &UpdateLogstashSettingsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateLogstashSettings", "/openapi/logstashes/[InstanceId]/instance-settings", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLogstashSettingsResponse creates a response to parse from UpdateLogstashSettings response
func CreateUpdateLogstashSettingsResponse() (response *UpdateLogstashSettingsResponse) {
	response = &UpdateLogstashSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
