package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddResourceToUsers invokes the emr.AddResourceToUsers API synchronously
// api document: https://help.aliyun.com/api/emr/addresourcetousers.html
func (client *Client) AddResourceToUsers(request *AddResourceToUsersRequest) (response *AddResourceToUsersResponse, err error) {
	response = CreateAddResourceToUsersResponse()
	err = client.DoAction(request, response)
	return
}

// AddResourceToUsersWithChan invokes the emr.AddResourceToUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/addresourcetousers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddResourceToUsersWithChan(request *AddResourceToUsersRequest) (<-chan *AddResourceToUsersResponse, <-chan error) {
	responseChan := make(chan *AddResourceToUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddResourceToUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddResourceToUsersWithCallback invokes the emr.AddResourceToUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/addresourcetousers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddResourceToUsersWithCallback(request *AddResourceToUsersRequest, callback func(response *AddResourceToUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddResourceToUsersResponse
		var err error
		defer close(result)
		response, err = client.AddResourceToUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddResourceToUsersRequest is the request struct for api AddResourceToUsers
type AddResourceToUsersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	UserIdList      *[]string        `position:"Query" name:"UserIdList"  type:"Repeated"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	RoleIdList      *[]string        `position:"Query" name:"RoleIdList"  type:"Repeated"`
}

// AddResourceToUsersResponse is the response struct for api AddResourceToUsers
type AddResourceToUsersResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateAddResourceToUsersRequest creates a request to invoke AddResourceToUsers API
func CreateAddResourceToUsersRequest() (request *AddResourceToUsersRequest) {
	request = &AddResourceToUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "AddResourceToUsers", "emr", "openAPI")
	return
}

// CreateAddResourceToUsersResponse creates a response to parse from AddResourceToUsers response
func CreateAddResourceToUsersResponse() (response *AddResourceToUsersResponse) {
	response = &AddResourceToUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
