package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBatchUsers invokes the emr.CreateBatchUsers API synchronously
// api document: https://help.aliyun.com/api/emr/createbatchusers.html
func (client *Client) CreateBatchUsers(request *CreateBatchUsersRequest) (response *CreateBatchUsersResponse, err error) {
	response = CreateCreateBatchUsersResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBatchUsersWithChan invokes the emr.CreateBatchUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/createbatchusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBatchUsersWithChan(request *CreateBatchUsersRequest) (<-chan *CreateBatchUsersResponse, <-chan error) {
	responseChan := make(chan *CreateBatchUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBatchUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBatchUsersWithCallback invokes the emr.CreateBatchUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/createbatchusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBatchUsersWithCallback(request *CreateBatchUsersRequest, callback func(response *CreateBatchUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBatchUsersResponse
		var err error
		defer close(result)
		response, err = client.CreateBatchUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBatchUsersRequest is the request struct for api CreateBatchUsers
type CreateBatchUsersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId   requests.Integer                     `position:"Query" name:"ResourceOwnerId"`
	UserBaseParamList *[]CreateBatchUsersUserBaseParamList `position:"Query" name:"UserBaseParamList"  type:"Repeated"`
	RoleId            *[]string                            `position:"Query" name:"RoleId"  type:"Repeated"`
	GroupId           *[]string                            `position:"Query" name:"GroupId"  type:"Repeated"`
	Description       string                               `position:"Query" name:"Description"`
}

// CreateBatchUsersUserBaseParamList is a repeated param struct in CreateBatchUsersRequest
type CreateBatchUsersUserBaseParamList struct {
	AliyunUserId string `name:"AliyunUserId"`
	UserName     string `name:"UserName"`
	UserType     string `name:"UserType"`
	IsSuperAdmin string `name:"IsSuperAdmin"`
}

// CreateBatchUsersResponse is the response struct for api CreateBatchUsers
type CreateBatchUsersResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCreateBatchUsersRequest creates a request to invoke CreateBatchUsers API
func CreateCreateBatchUsersRequest() (request *CreateBatchUsersRequest) {
	request = &CreateBatchUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateBatchUsers", "emr", "openAPI")
	return
}

// CreateCreateBatchUsersResponse creates a response to parse from CreateBatchUsers response
func CreateCreateBatchUsersResponse() (response *CreateBatchUsersResponse) {
	response = &CreateBatchUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
