package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateHostPool invokes the emr.CreateHostPool API synchronously
// api document: https://help.aliyun.com/api/emr/createhostpool.html
func (client *Client) CreateHostPool(request *CreateHostPoolRequest) (response *CreateHostPoolResponse, err error) {
	response = CreateCreateHostPoolResponse()
	err = client.DoAction(request, response)
	return
}

// CreateHostPoolWithChan invokes the emr.CreateHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/createhostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateHostPoolWithChan(request *CreateHostPoolRequest) (<-chan *CreateHostPoolResponse, <-chan error) {
	responseChan := make(chan *CreateHostPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateHostPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateHostPoolWithCallback invokes the emr.CreateHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/createhostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateHostPoolWithCallback(request *CreateHostPoolRequest, callback func(response *CreateHostPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateHostPoolResponse
		var err error
		defer close(result)
		response, err = client.CreateHostPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateHostPoolRequest is the request struct for api CreateHostPool
type CreateHostPoolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer                 `position:"Query" name:"ResourceOwnerId"`
	Name            string                           `position:"Query" name:"Name"`
	Description     string                           `position:"Query" name:"Description"`
	KubeClusterInfo *[]CreateHostPoolKubeClusterInfo `position:"Query" name:"KubeClusterInfo"  type:"Repeated"`
	Type            string                           `position:"Query" name:"Type"`
}

// CreateHostPoolKubeClusterInfo is a repeated param struct in CreateHostPoolRequest
type CreateHostPoolKubeClusterInfo struct {
	ExternalKey    string `name:"ExternalKey"`
	InternalConfig string `name:"InternalConfig"`
	PublicConfig   string `name:"PublicConfig"`
	SshConfig      string `name:"SshConfig"`
}

// CreateHostPoolResponse is the response struct for api CreateHostPool
type CreateHostPoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	BizId     string `json:"BizId" xml:"BizId"`
}

// CreateCreateHostPoolRequest creates a request to invoke CreateHostPool API
func CreateCreateHostPoolRequest() (request *CreateHostPoolRequest) {
	request = &CreateHostPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateHostPool", "emr", "openAPI")
	return
}

// CreateCreateHostPoolResponse creates a response to parse from CreateHostPool response
func CreateCreateHostPoolResponse() (response *CreateHostPoolResponse) {
	response = &CreateHostPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
