package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserResourceRole invokes the emr.DeleteUserResourceRole API synchronously
// api document: https://help.aliyun.com/api/emr/deleteuserresourcerole.html
func (client *Client) DeleteUserResourceRole(request *DeleteUserResourceRoleRequest) (response *DeleteUserResourceRoleResponse, err error) {
	response = CreateDeleteUserResourceRoleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserResourceRoleWithChan invokes the emr.DeleteUserResourceRole API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteuserresourcerole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUserResourceRoleWithChan(request *DeleteUserResourceRoleRequest) (<-chan *DeleteUserResourceRoleResponse, <-chan error) {
	responseChan := make(chan *DeleteUserResourceRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserResourceRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserResourceRoleWithCallback invokes the emr.DeleteUserResourceRole API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteuserresourcerole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUserResourceRoleWithCallback(request *DeleteUserResourceRoleRequest, callback func(response *DeleteUserResourceRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserResourceRoleResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserResourceRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserResourceRoleRequest is the request struct for api DeleteUserResourceRole
type DeleteUserResourceRoleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	RoleId          requests.Integer `position:"Query" name:"RoleId"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	AliyunUserId    string           `position:"Query" name:"AliyunUserId"`
}

// DeleteUserResourceRoleResponse is the response struct for api DeleteUserResourceRole
type DeleteUserResourceRoleResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteUserResourceRoleRequest creates a request to invoke DeleteUserResourceRole API
func CreateDeleteUserResourceRoleRequest() (request *DeleteUserResourceRoleRequest) {
	request = &DeleteUserResourceRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteUserResourceRole", "emr", "openAPI")
	return
}

// CreateDeleteUserResourceRoleResponse creates a response to parse from DeleteUserResourceRole response
func CreateDeleteUserResourceRoleResponse() (response *DeleteUserResourceRoleResponse) {
	response = &DeleteUserResourceRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
