package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterServiceConfigTagForAdmin invokes the emr.DescribeClusterServiceConfigTagForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfigtagforadmin.html
func (client *Client) DescribeClusterServiceConfigTagForAdmin(request *DescribeClusterServiceConfigTagForAdminRequest) (response *DescribeClusterServiceConfigTagForAdminResponse, err error) {
	response = CreateDescribeClusterServiceConfigTagForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterServiceConfigTagForAdminWithChan invokes the emr.DescribeClusterServiceConfigTagForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfigtagforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServiceConfigTagForAdminWithChan(request *DescribeClusterServiceConfigTagForAdminRequest) (<-chan *DescribeClusterServiceConfigTagForAdminResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterServiceConfigTagForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterServiceConfigTagForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterServiceConfigTagForAdminWithCallback invokes the emr.DescribeClusterServiceConfigTagForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfigtagforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServiceConfigTagForAdminWithCallback(request *DescribeClusterServiceConfigTagForAdminRequest, callback func(response *DescribeClusterServiceConfigTagForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterServiceConfigTagForAdminResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterServiceConfigTagForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterServiceConfigTagForAdminRequest is the request struct for api DescribeClusterServiceConfigTagForAdmin
type DescribeClusterServiceConfigTagForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ConfigTag       string           `position:"Query" name:"ConfigTag"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
}

// DescribeClusterServiceConfigTagForAdminResponse is the response struct for api DescribeClusterServiceConfigTagForAdmin
type DescribeClusterServiceConfigTagForAdminResponse struct {
	*responses.BaseResponse
	RequestId     string                                                 `json:"RequestId" xml:"RequestId"`
	ConfigTagList ConfigTagListInDescribeClusterServiceConfigTagForAdmin `json:"ConfigTagList" xml:"ConfigTagList"`
}

// CreateDescribeClusterServiceConfigTagForAdminRequest creates a request to invoke DescribeClusterServiceConfigTagForAdmin API
func CreateDescribeClusterServiceConfigTagForAdminRequest() (request *DescribeClusterServiceConfigTagForAdminRequest) {
	request = &DescribeClusterServiceConfigTagForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeClusterServiceConfigTagForAdmin", "emr", "openAPI")
	return
}

// CreateDescribeClusterServiceConfigTagForAdminResponse creates a response to parse from DescribeClusterServiceConfigTagForAdmin response
func CreateDescribeClusterServiceConfigTagForAdminResponse() (response *DescribeClusterServiceConfigTagForAdminResponse) {
	response = &DescribeClusterServiceConfigTagForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
