package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataSourceSchemaTable invokes the emr.DescribeDataSourceSchemaTable API synchronously
// api document: https://help.aliyun.com/api/emr/describedatasourceschematable.html
func (client *Client) DescribeDataSourceSchemaTable(request *DescribeDataSourceSchemaTableRequest) (response *DescribeDataSourceSchemaTableResponse, err error) {
	response = CreateDescribeDataSourceSchemaTableResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataSourceSchemaTableWithChan invokes the emr.DescribeDataSourceSchemaTable API asynchronously
// api document: https://help.aliyun.com/api/emr/describedatasourceschematable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataSourceSchemaTableWithChan(request *DescribeDataSourceSchemaTableRequest) (<-chan *DescribeDataSourceSchemaTableResponse, <-chan error) {
	responseChan := make(chan *DescribeDataSourceSchemaTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataSourceSchemaTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataSourceSchemaTableWithCallback invokes the emr.DescribeDataSourceSchemaTable API asynchronously
// api document: https://help.aliyun.com/api/emr/describedatasourceschematable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataSourceSchemaTableWithCallback(request *DescribeDataSourceSchemaTableRequest, callback func(response *DescribeDataSourceSchemaTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataSourceSchemaTableResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataSourceSchemaTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataSourceSchemaTableRequest is the request struct for api DescribeDataSourceSchemaTable
type DescribeDataSourceSchemaTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	DataSourceId    string           `position:"Query" name:"DataSourceId"`
	TableName       string           `position:"Query" name:"TableName"`
}

// DescribeDataSourceSchemaTableResponse is the response struct for api DescribeDataSourceSchemaTable
type DescribeDataSourceSchemaTableResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DataSourceId string `json:"DataSourceId" xml:"DataSourceId"`
	Schema       Schema `json:"Schema" xml:"Schema"`
}

// CreateDescribeDataSourceSchemaTableRequest creates a request to invoke DescribeDataSourceSchemaTable API
func CreateDescribeDataSourceSchemaTableRequest() (request *DescribeDataSourceSchemaTableRequest) {
	request = &DescribeDataSourceSchemaTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeDataSourceSchemaTable", "emr", "openAPI")
	return
}

// CreateDescribeDataSourceSchemaTableResponse creates a response to parse from DescribeDataSourceSchemaTable response
func CreateDescribeDataSourceSchemaTableResponse() (response *DescribeDataSourceSchemaTableResponse) {
	response = &DescribeDataSourceSchemaTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
