package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserGroup invokes the emr.DescribeUserGroup API synchronously
// api document: https://help.aliyun.com/api/emr/describeusergroup.html
func (client *Client) DescribeUserGroup(request *DescribeUserGroupRequest) (response *DescribeUserGroupResponse, err error) {
	response = CreateDescribeUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserGroupWithChan invokes the emr.DescribeUserGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/describeusergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserGroupWithChan(request *DescribeUserGroupRequest) (<-chan *DescribeUserGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserGroupWithCallback invokes the emr.DescribeUserGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/describeusergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserGroupWithCallback(request *DescribeUserGroupRequest, callback func(response *DescribeUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserGroupRequest is the request struct for api DescribeUserGroup
type DescribeUserGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	GroupId         requests.Integer `position:"Query" name:"GroupId"`
}

// DescribeUserGroupResponse is the response struct for api DescribeUserGroup
type DescribeUserGroupResponse struct {
	*responses.BaseResponse
	Paging      bool                           `json:"Paging" xml:"Paging"`
	RequestId   string                         `json:"RequestId" xml:"RequestId"`
	Id          int64                          `json:"Id" xml:"Id"`
	Type        string                         `json:"Type" xml:"Type"`
	Name        string                         `json:"Name" xml:"Name"`
	GmtCreate   string                         `json:"GmtCreate" xml:"GmtCreate"`
	RoleDTOList RoleDTOListInDescribeUserGroup `json:"RoleDTOList" xml:"RoleDTOList"`
}

// CreateDescribeUserGroupRequest creates a request to invoke DescribeUserGroup API
func CreateDescribeUserGroupRequest() (request *DescribeUserGroupRequest) {
	request = &DescribeUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeUserGroup", "emr", "openAPI")
	return
}

// CreateDescribeUserGroupResponse creates a response to parse from DescribeUserGroup response
func CreateDescribeUserGroupResponse() (response *DescribeUserGroupResponse) {
	response = &DescribeUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
