package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWorkspaceResourceSetting invokes the emr.DescribeWorkspaceResourceSetting API synchronously
// api document: https://help.aliyun.com/api/emr/describeworkspaceresourcesetting.html
func (client *Client) DescribeWorkspaceResourceSetting(request *DescribeWorkspaceResourceSettingRequest) (response *DescribeWorkspaceResourceSettingResponse, err error) {
	response = CreateDescribeWorkspaceResourceSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWorkspaceResourceSettingWithChan invokes the emr.DescribeWorkspaceResourceSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/describeworkspaceresourcesetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWorkspaceResourceSettingWithChan(request *DescribeWorkspaceResourceSettingRequest) (<-chan *DescribeWorkspaceResourceSettingResponse, <-chan error) {
	responseChan := make(chan *DescribeWorkspaceResourceSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWorkspaceResourceSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWorkspaceResourceSettingWithCallback invokes the emr.DescribeWorkspaceResourceSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/describeworkspaceresourcesetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWorkspaceResourceSettingWithCallback(request *DescribeWorkspaceResourceSettingRequest, callback func(response *DescribeWorkspaceResourceSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWorkspaceResourceSettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeWorkspaceResourceSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWorkspaceResourceSettingRequest is the request struct for api DescribeWorkspaceResourceSetting
type DescribeWorkspaceResourceSettingRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	WorkspaceId     string           `position:"Query" name:"WorkspaceId"`
}

// DescribeWorkspaceResourceSettingResponse is the response struct for api DescribeWorkspaceResourceSetting
type DescribeWorkspaceResourceSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Oss       Oss    `json:"Oss" xml:"Oss"`
}

// CreateDescribeWorkspaceResourceSettingRequest creates a request to invoke DescribeWorkspaceResourceSetting API
func CreateDescribeWorkspaceResourceSettingRequest() (request *DescribeWorkspaceResourceSettingRequest) {
	request = &DescribeWorkspaceResourceSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeWorkspaceResourceSetting", "emr", "openAPI")
	return
}

// CreateDescribeWorkspaceResourceSettingResponse creates a response to parse from DescribeWorkspaceResourceSetting response
func CreateDescribeWorkspaceResourceSettingResponse() (response *DescribeWorkspaceResourceSettingResponse) {
	response = &DescribeWorkspaceResourceSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
