package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBackPlanInfo invokes the emr.GetBackPlanInfo API synchronously
// api document: https://help.aliyun.com/api/emr/getbackplaninfo.html
func (client *Client) GetBackPlanInfo(request *GetBackPlanInfoRequest) (response *GetBackPlanInfoResponse, err error) {
	response = CreateGetBackPlanInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetBackPlanInfoWithChan invokes the emr.GetBackPlanInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getbackplaninfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBackPlanInfoWithChan(request *GetBackPlanInfoRequest) (<-chan *GetBackPlanInfoResponse, <-chan error) {
	responseChan := make(chan *GetBackPlanInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBackPlanInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBackPlanInfoWithCallback invokes the emr.GetBackPlanInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getbackplaninfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBackPlanInfoWithCallback(request *GetBackPlanInfoRequest, callback func(response *GetBackPlanInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBackPlanInfoResponse
		var err error
		defer close(result)
		response, err = client.GetBackPlanInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBackPlanInfoRequest is the request struct for api GetBackPlanInfo
type GetBackPlanInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BackupPlanId    string           `position:"Query" name:"BackupPlanId"`
}

// GetBackPlanInfoResponse is the response struct for api GetBackPlanInfo
type GetBackPlanInfoResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Id          string `json:"Id" xml:"Id"`
	Name        string `json:"Name" xml:"Name"`
	Description string `json:"Description" xml:"Description"`
	ClusterId   string `json:"ClusterId" xml:"ClusterId"`
	RootPath    string `json:"RootPath" xml:"RootPath"`
}

// CreateGetBackPlanInfoRequest creates a request to invoke GetBackPlanInfo API
func CreateGetBackPlanInfoRequest() (request *GetBackPlanInfoRequest) {
	request = &GetBackPlanInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetBackPlanInfo", "emr", "openAPI")
	return
}

// CreateGetBackPlanInfoResponse creates a response to parse from GetBackPlanInfo response
func CreateGetBackPlanInfoResponse() (response *GetBackPlanInfoResponse) {
	response = &GetBackPlanInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
