package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueueInputStatisticInfo invokes the emr.GetQueueInputStatisticInfo API synchronously
// api document: https://help.aliyun.com/api/emr/getqueueinputstatisticinfo.html
func (client *Client) GetQueueInputStatisticInfo(request *GetQueueInputStatisticInfoRequest) (response *GetQueueInputStatisticInfoResponse, err error) {
	response = CreateGetQueueInputStatisticInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueueInputStatisticInfoWithChan invokes the emr.GetQueueInputStatisticInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getqueueinputstatisticinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetQueueInputStatisticInfoWithChan(request *GetQueueInputStatisticInfoRequest) (<-chan *GetQueueInputStatisticInfoResponse, <-chan error) {
	responseChan := make(chan *GetQueueInputStatisticInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueueInputStatisticInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueueInputStatisticInfoWithCallback invokes the emr.GetQueueInputStatisticInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getqueueinputstatisticinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetQueueInputStatisticInfoWithCallback(request *GetQueueInputStatisticInfoRequest, callback func(response *GetQueueInputStatisticInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueueInputStatisticInfoResponse
		var err error
		defer close(result)
		response, err = client.GetQueueInputStatisticInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueueInputStatisticInfoRequest is the request struct for api GetQueueInputStatisticInfo
type GetQueueInputStatisticInfoRequest struct {
	*requests.RpcRequest
	FromDatetime    string           `position:"Query" name:"FromDatetime"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ToDatetime      string           `position:"Query" name:"ToDatetime"`
}

// GetQueueInputStatisticInfoResponse is the response struct for api GetQueueInputStatisticInfo
type GetQueueInputStatisticInfoResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	QueueInputList QueueInputList `json:"QueueInputList" xml:"QueueInputList"`
}

// CreateGetQueueInputStatisticInfoRequest creates a request to invoke GetQueueInputStatisticInfo API
func CreateGetQueueInputStatisticInfoRequest() (request *GetQueueInputStatisticInfoRequest) {
	request = &GetQueueInputStatisticInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetQueueInputStatisticInfo", "emr", "openAPI")
	return
}

// CreateGetQueueInputStatisticInfoResponse creates a response to parse from GetQueueInputStatisticInfo response
func CreateGetQueueInputStatisticInfoResponse() (response *GetQueueInputStatisticInfoResponse) {
	response = &GetQueueInputStatisticInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
