package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterServiceConfigHistoryForAdmin invokes the emr.ListClusterServiceConfigHistoryForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/listclusterserviceconfighistoryforadmin.html
func (client *Client) ListClusterServiceConfigHistoryForAdmin(request *ListClusterServiceConfigHistoryForAdminRequest) (response *ListClusterServiceConfigHistoryForAdminResponse, err error) {
	response = CreateListClusterServiceConfigHistoryForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterServiceConfigHistoryForAdminWithChan invokes the emr.ListClusterServiceConfigHistoryForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterserviceconfighistoryforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterServiceConfigHistoryForAdminWithChan(request *ListClusterServiceConfigHistoryForAdminRequest) (<-chan *ListClusterServiceConfigHistoryForAdminResponse, <-chan error) {
	responseChan := make(chan *ListClusterServiceConfigHistoryForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterServiceConfigHistoryForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterServiceConfigHistoryForAdminWithCallback invokes the emr.ListClusterServiceConfigHistoryForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterserviceconfighistoryforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterServiceConfigHistoryForAdminWithCallback(request *ListClusterServiceConfigHistoryForAdminRequest, callback func(response *ListClusterServiceConfigHistoryForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterServiceConfigHistoryForAdminResponse
		var err error
		defer close(result)
		response, err = client.ListClusterServiceConfigHistoryForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterServiceConfigHistoryForAdminRequest is the request struct for api ListClusterServiceConfigHistoryForAdmin
type ListClusterServiceConfigHistoryForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ConfigVersion   string           `position:"Query" name:"ConfigVersion"`
}

// ListClusterServiceConfigHistoryForAdminResponse is the response struct for api ListClusterServiceConfigHistoryForAdmin
type ListClusterServiceConfigHistoryForAdminResponse struct {
	*responses.BaseResponse
	RequestId         string                                                     `json:"RequestId" xml:"RequestId"`
	TotalCount        int                                                        `json:"TotalCount" xml:"TotalCount"`
	PageNumber        int                                                        `json:"PageNumber" xml:"PageNumber"`
	PageSize          int                                                        `json:"PageSize" xml:"PageSize"`
	ConfigHistoryList ConfigHistoryListInListClusterServiceConfigHistoryForAdmin `json:"ConfigHistoryList" xml:"ConfigHistoryList"`
}

// CreateListClusterServiceConfigHistoryForAdminRequest creates a request to invoke ListClusterServiceConfigHistoryForAdmin API
func CreateListClusterServiceConfigHistoryForAdminRequest() (request *ListClusterServiceConfigHistoryForAdminRequest) {
	request = &ListClusterServiceConfigHistoryForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterServiceConfigHistoryForAdmin", "emr", "openAPI")
	return
}

// CreateListClusterServiceConfigHistoryForAdminResponse creates a response to parse from ListClusterServiceConfigHistoryForAdmin response
func CreateListClusterServiceConfigHistoryForAdminResponse() (response *ListClusterServiceConfigHistoryForAdminResponse) {
	response = &ListClusterServiceConfigHistoryForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
