package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHpHost invokes the emr.ListHpHost API synchronously
// api document: https://help.aliyun.com/api/emr/listhphost.html
func (client *Client) ListHpHost(request *ListHpHostRequest) (response *ListHpHostResponse, err error) {
	response = CreateListHpHostResponse()
	err = client.DoAction(request, response)
	return
}

// ListHpHostWithChan invokes the emr.ListHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/listhphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListHpHostWithChan(request *ListHpHostRequest) (<-chan *ListHpHostResponse, <-chan error) {
	responseChan := make(chan *ListHpHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHpHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHpHostWithCallback invokes the emr.ListHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/listhphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListHpHostWithCallback(request *ListHpHostRequest, callback func(response *ListHpHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHpHostResponse
		var err error
		defer close(result)
		response, err = client.ListHpHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHpHostRequest is the request struct for api ListHpHost
type ListHpHostRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Role            string           `position:"Query" name:"Role"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	HpBizId         string           `position:"Query" name:"HpBizId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Status          string           `position:"Query" name:"Status"`
}

// ListHpHostResponse is the response struct for api ListHpHost
type ListHpHostResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	HpHostList HpHostList `json:"HpHostList" xml:"HpHostList"`
}

// CreateListHpHostRequest creates a request to invoke ListHpHost API
func CreateListHpHostRequest() (request *ListHpHostRequest) {
	request = &ListHpHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListHpHost", "emr", "openAPI")
	return
}

// CreateListHpHostResponse creates a response to parse from ListHpHost response
func CreateListHpHostResponse() (response *ListHpHostResponse) {
	response = &ListHpHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
