package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOpsOperationTask invokes the emr.ListOpsOperationTask API synchronously
// api document: https://help.aliyun.com/api/emr/listopsoperationtask.html
func (client *Client) ListOpsOperationTask(request *ListOpsOperationTaskRequest) (response *ListOpsOperationTaskResponse, err error) {
	response = CreateListOpsOperationTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListOpsOperationTaskWithChan invokes the emr.ListOpsOperationTask API asynchronously
// api document: https://help.aliyun.com/api/emr/listopsoperationtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListOpsOperationTaskWithChan(request *ListOpsOperationTaskRequest) (<-chan *ListOpsOperationTaskResponse, <-chan error) {
	responseChan := make(chan *ListOpsOperationTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOpsOperationTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOpsOperationTaskWithCallback invokes the emr.ListOpsOperationTask API asynchronously
// api document: https://help.aliyun.com/api/emr/listopsoperationtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListOpsOperationTaskWithCallback(request *ListOpsOperationTaskRequest, callback func(response *ListOpsOperationTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOpsOperationTaskResponse
		var err error
		defer close(result)
		response, err = client.ListOpsOperationTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOpsOperationTaskRequest is the request struct for api ListOpsOperationTask
type ListOpsOperationTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OperationId     requests.Integer `position:"Query" name:"OperationId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// ListOpsOperationTaskResponse is the response struct for api ListOpsOperationTask
type ListOpsOperationTaskResponse struct {
	*responses.BaseResponse
	RequestId  string                         `json:"RequestId" xml:"RequestId"`
	Total      int                            `json:"Total" xml:"Total"`
	PageNumber int                            `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                            `json:"PageSize" xml:"PageSize"`
	TaskList   TaskListInListOpsOperationTask `json:"TaskList" xml:"TaskList"`
}

// CreateListOpsOperationTaskRequest creates a request to invoke ListOpsOperationTask API
func CreateListOpsOperationTaskRequest() (request *ListOpsOperationTaskRequest) {
	request = &ListOpsOperationTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListOpsOperationTask", "emr", "openAPI")
	return
}

// CreateListOpsOperationTaskResponse creates a response to parse from ListOpsOperationTask response
func CreateListOpsOperationTaskResponse() (response *ListOpsOperationTaskResponse) {
	response = &ListOpsOperationTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
