package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFlowForWeb invokes the emr.ModifyFlowForWeb API synchronously
// api document: https://help.aliyun.com/api/emr/modifyflowforweb.html
func (client *Client) ModifyFlowForWeb(request *ModifyFlowForWebRequest) (response *ModifyFlowForWebResponse, err error) {
	response = CreateModifyFlowForWebResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFlowForWebWithChan invokes the emr.ModifyFlowForWeb API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflowforweb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowForWebWithChan(request *ModifyFlowForWebRequest) (<-chan *ModifyFlowForWebResponse, <-chan error) {
	responseChan := make(chan *ModifyFlowForWebResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFlowForWeb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFlowForWebWithCallback invokes the emr.ModifyFlowForWeb API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflowforweb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowForWebWithCallback(request *ModifyFlowForWebRequest, callback func(response *ModifyFlowForWebResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFlowForWebResponse
		var err error
		defer close(result)
		response, err = client.ModifyFlowForWeb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFlowForWebRequest is the request struct for api ModifyFlowForWeb
type ModifyFlowForWebRequest struct {
	*requests.RpcRequest
	CronExpr                string           `position:"Query" name:"CronExpr"`
	ParentFlowList          string           `position:"Query" name:"ParentFlowList"`
	AlertDingDingGroupBizId string           `position:"Query" name:"AlertDingDingGroupBizId"`
	Periodic                requests.Boolean `position:"Query" name:"Periodic"`
	StartSchedule           requests.Integer `position:"Query" name:"StartSchedule"`
	Description             string           `position:"Query" name:"Description"`
	ClusterId               string           `position:"Query" name:"ClusterId"`
	AlertUserGroupBizId     string           `position:"Query" name:"AlertUserGroupBizId"`
	Graph                   string           `position:"Query" name:"Graph"`
	HostName                string           `position:"Query" name:"HostName"`
	CreateCluster           requests.Boolean `position:"Query" name:"CreateCluster"`
	Name                    string           `position:"Query" name:"Name"`
	EndSchedule             requests.Integer `position:"Query" name:"EndSchedule"`
	Id                      string           `position:"Query" name:"Id"`
	AlertConf               string           `position:"Query" name:"AlertConf"`
	ProjectId               string           `position:"Query" name:"ProjectId"`
	Status                  string           `position:"Query" name:"Status"`
	ParentCategory          string           `position:"Query" name:"ParentCategory"`
}

// ModifyFlowForWebResponse is the response struct for api ModifyFlowForWeb
type ModifyFlowForWebResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateModifyFlowForWebRequest creates a request to invoke ModifyFlowForWeb API
func CreateModifyFlowForWebRequest() (request *ModifyFlowForWebRequest) {
	request = &ModifyFlowForWebRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyFlowForWeb", "emr", "openAPI")
	return
}

// CreateModifyFlowForWebResponse creates a response to parse from ModifyFlowForWeb response
func CreateModifyFlowForWebResponse() (response *ModifyFlowForWebResponse) {
	response = &ModifyFlowForWebResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
