package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PageListResourceUsers invokes the emr.PageListResourceUsers API synchronously
// api document: https://help.aliyun.com/api/emr/pagelistresourceusers.html
func (client *Client) PageListResourceUsers(request *PageListResourceUsersRequest) (response *PageListResourceUsersResponse, err error) {
	response = CreatePageListResourceUsersResponse()
	err = client.DoAction(request, response)
	return
}

// PageListResourceUsersWithChan invokes the emr.PageListResourceUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/pagelistresourceusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PageListResourceUsersWithChan(request *PageListResourceUsersRequest) (<-chan *PageListResourceUsersResponse, <-chan error) {
	responseChan := make(chan *PageListResourceUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PageListResourceUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PageListResourceUsersWithCallback invokes the emr.PageListResourceUsers API asynchronously
// api document: https://help.aliyun.com/api/emr/pagelistresourceusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PageListResourceUsersWithCallback(request *PageListResourceUsersRequest, callback func(response *PageListResourceUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PageListResourceUsersResponse
		var err error
		defer close(result)
		response, err = client.PageListResourceUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PageListResourceUsersRequest is the request struct for api PageListResourceUsers
type PageListResourceUsersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	SearchKey       string           `position:"Query" name:"SearchKey"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
}

// PageListResourceUsersResponse is the response struct for api PageListResourceUsers
type PageListResourceUsersResponse struct {
	*responses.BaseResponse
	Paging     bool                         `json:"Paging" xml:"Paging"`
	RequestId  string                       `json:"RequestId" xml:"RequestId"`
	PageNumber int                          `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                          `json:"PageSize" xml:"PageSize"`
	TotalCount int                          `json:"TotalCount" xml:"TotalCount"`
	Items      ItemsInPageListResourceUsers `json:"Items" xml:"Items"`
}

// CreatePageListResourceUsersRequest creates a request to invoke PageListResourceUsers API
func CreatePageListResourceUsersRequest() (request *PageListResourceUsersRequest) {
	request = &PageListResourceUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "PageListResourceUsers", "emr", "openAPI")
	return
}

// CreatePageListResourceUsersResponse creates a response to parse from PageListResourceUsers response
func CreatePageListResourceUsersResponse() (response *PageListResourceUsersResponse) {
	response = &PageListResourceUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
