package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWorkspaceResourceSetting invokes the emr.UpdateWorkspaceResourceSetting API synchronously
// api document: https://help.aliyun.com/api/emr/updateworkspaceresourcesetting.html
func (client *Client) UpdateWorkspaceResourceSetting(request *UpdateWorkspaceResourceSettingRequest) (response *UpdateWorkspaceResourceSettingResponse, err error) {
	response = CreateUpdateWorkspaceResourceSettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWorkspaceResourceSettingWithChan invokes the emr.UpdateWorkspaceResourceSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/updateworkspaceresourcesetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWorkspaceResourceSettingWithChan(request *UpdateWorkspaceResourceSettingRequest) (<-chan *UpdateWorkspaceResourceSettingResponse, <-chan error) {
	responseChan := make(chan *UpdateWorkspaceResourceSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWorkspaceResourceSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWorkspaceResourceSettingWithCallback invokes the emr.UpdateWorkspaceResourceSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/updateworkspaceresourcesetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWorkspaceResourceSettingWithCallback(request *UpdateWorkspaceResourceSettingRequest, callback func(response *UpdateWorkspaceResourceSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWorkspaceResourceSettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateWorkspaceResourceSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWorkspaceResourceSettingRequest is the request struct for api UpdateWorkspaceResourceSetting
type UpdateWorkspaceResourceSettingRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	WorkspaceId     string           `position:"Query" name:"WorkspaceId"`
	OssSetting      string           `position:"Query" name:"OssSetting"`
}

// UpdateWorkspaceResourceSettingResponse is the response struct for api UpdateWorkspaceResourceSetting
type UpdateWorkspaceResourceSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateWorkspaceResourceSettingRequest creates a request to invoke UpdateWorkspaceResourceSetting API
func CreateUpdateWorkspaceResourceSettingRequest() (request *UpdateWorkspaceResourceSettingRequest) {
	request = &UpdateWorkspaceResourceSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "UpdateWorkspaceResourceSetting", "emr", "openAPI")
	return
}

// CreateUpdateWorkspaceResourceSettingResponse creates a response to parse from UpdateWorkspaceResourceSetting response
func CreateUpdateWorkspaceResourceSettingResponse() (response *UpdateWorkspaceResourceSettingResponse) {
	response = &UpdateWorkspaceResourceSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
