package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleasePrePaidInstance invokes the ens.ReleasePrePaidInstance API synchronously
// api document: https://help.aliyun.com/api/ens/releaseprepaidinstance.html
func (client *Client) ReleasePrePaidInstance(request *ReleasePrePaidInstanceRequest) (response *ReleasePrePaidInstanceResponse, err error) {
	response = CreateReleasePrePaidInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ReleasePrePaidInstanceWithChan invokes the ens.ReleasePrePaidInstance API asynchronously
// api document: https://help.aliyun.com/api/ens/releaseprepaidinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReleasePrePaidInstanceWithChan(request *ReleasePrePaidInstanceRequest) (<-chan *ReleasePrePaidInstanceResponse, <-chan error) {
	responseChan := make(chan *ReleasePrePaidInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleasePrePaidInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleasePrePaidInstanceWithCallback invokes the ens.ReleasePrePaidInstance API asynchronously
// api document: https://help.aliyun.com/api/ens/releaseprepaidinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReleasePrePaidInstanceWithCallback(request *ReleasePrePaidInstanceRequest, callback func(response *ReleasePrePaidInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleasePrePaidInstanceResponse
		var err error
		defer close(result)
		response, err = client.ReleasePrePaidInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleasePrePaidInstanceRequest is the request struct for api ReleasePrePaidInstance
type ReleasePrePaidInstanceRequest struct {
	*requests.RpcRequest
	Version    string `position:"Query" name:"Version"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ReleasePrePaidInstanceResponse is the response struct for api ReleasePrePaidInstance
type ReleasePrePaidInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleasePrePaidInstanceRequest creates a request to invoke ReleasePrePaidInstance API
func CreateReleasePrePaidInstanceRequest() (request *ReleasePrePaidInstanceRequest) {
	request = &ReleasePrePaidInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ReleasePrePaidInstance", "ens", "openAPI")
	return
}

// CreateReleasePrePaidInstanceResponse creates a response to parse from ReleasePrePaidInstance response
func CreateReleasePrePaidInstanceResponse() (response *ReleasePrePaidInstanceResponse) {
	response = &ReleasePrePaidInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
