package fnf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartExecution invokes the fnf.StartExecution API synchronously
// api document: https://help.aliyun.com/api/fnf/startexecution.html
func (client *Client) StartExecution(request *StartExecutionRequest) (response *StartExecutionResponse, err error) {
	response = CreateStartExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// StartExecutionWithChan invokes the fnf.StartExecution API asynchronously
// api document: https://help.aliyun.com/api/fnf/startexecution.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartExecutionWithChan(request *StartExecutionRequest) (<-chan *StartExecutionResponse, <-chan error) {
	responseChan := make(chan *StartExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartExecutionWithCallback invokes the fnf.StartExecution API asynchronously
// api document: https://help.aliyun.com/api/fnf/startexecution.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartExecutionWithCallback(request *StartExecutionRequest, callback func(response *StartExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartExecutionResponse
		var err error
		defer close(result)
		response, err = client.StartExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartExecutionRequest is the request struct for api StartExecution
type StartExecutionRequest struct {
	*requests.RpcRequest
	Input         string `position:"Body" name:"Input"`
	ExecutionName string `position:"Body" name:"ExecutionName"`
	RequestId     string `position:"Query" name:"RequestId"`
	FlowName      string `position:"Body" name:"FlowName"`
}

// StartExecutionResponse is the response struct for api StartExecution
type StartExecutionResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Name           string `json:"Name" xml:"Name"`
	FlowName       string `json:"FlowName" xml:"FlowName"`
	FlowDefinition string `json:"FlowDefinition" xml:"FlowDefinition"`
	Input          string `json:"Input" xml:"Input"`
	Output         string `json:"Output" xml:"Output"`
	Status         string `json:"Status" xml:"Status"`
	StartedTime    string `json:"StartedTime" xml:"StartedTime"`
	StoppedTime    string `json:"StoppedTime" xml:"StoppedTime"`
}

// CreateStartExecutionRequest creates a request to invoke StartExecution API
func CreateStartExecutionRequest() (request *StartExecutionRequest) {
	request = &StartExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("fnf", "2019-03-15", "StartExecution", "fnf", "openAPI")
	return
}

// CreateStartExecutionResponse creates a response to parse from StartExecution response
func CreateStartExecutionResponse() (response *StartExecutionResponse) {
	response = &StartExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
