package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFolder invokes the foas.GetFolder API synchronously
// api document: https://help.aliyun.com/api/foas/getfolder.html
func (client *Client) GetFolder(request *GetFolderRequest) (response *GetFolderResponse, err error) {
	response = CreateGetFolderResponse()
	err = client.DoAction(request, response)
	return
}

// GetFolderWithChan invokes the foas.GetFolder API asynchronously
// api document: https://help.aliyun.com/api/foas/getfolder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetFolderWithChan(request *GetFolderRequest) (<-chan *GetFolderResponse, <-chan error) {
	responseChan := make(chan *GetFolderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFolder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFolderWithCallback invokes the foas.GetFolder API asynchronously
// api document: https://help.aliyun.com/api/foas/getfolder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetFolderWithCallback(request *GetFolderRequest, callback func(response *GetFolderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFolderResponse
		var err error
		defer close(result)
		response, err = client.GetFolder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFolderRequest is the request struct for api GetFolder
type GetFolderRequest struct {
	*requests.RoaRequest
	Path        string `position:"Query" name:"path"`
	ProjectName string `position:"Path" name:"projectName"`
}

// GetFolderResponse is the response struct for api GetFolder
type GetFolderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Folder    Folder `json:"Folder" xml:"Folder"`
}

// CreateGetFolderRequest creates a request to invoke GetFolder API
func CreateGetFolderRequest() (request *GetFolderRequest) {
	request = &GetFolderRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetFolder", "/api/v2/projects/[projectName]/folders", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetFolderResponse creates a response to parse from GetFolder response
func CreateGetFolderResponse() (response *GetFolderResponse) {
	response = &GetFolderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
