package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAutoScaleConfig invokes the foas.UpdateAutoScaleConfig API synchronously
// api document: https://help.aliyun.com/api/foas/updateautoscaleconfig.html
func (client *Client) UpdateAutoScaleConfig(request *UpdateAutoScaleConfigRequest) (response *UpdateAutoScaleConfigResponse, err error) {
	response = CreateUpdateAutoScaleConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAutoScaleConfigWithChan invokes the foas.UpdateAutoScaleConfig API asynchronously
// api document: https://help.aliyun.com/api/foas/updateautoscaleconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAutoScaleConfigWithChan(request *UpdateAutoScaleConfigRequest) (<-chan *UpdateAutoScaleConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateAutoScaleConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAutoScaleConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAutoScaleConfigWithCallback invokes the foas.UpdateAutoScaleConfig API asynchronously
// api document: https://help.aliyun.com/api/foas/updateautoscaleconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAutoScaleConfigWithCallback(request *UpdateAutoScaleConfigRequest, callback func(response *UpdateAutoScaleConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAutoScaleConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateAutoScaleConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAutoScaleConfigRequest is the request struct for api UpdateAutoScaleConfig
type UpdateAutoScaleConfigRequest struct {
	*requests.RoaRequest
	ProjectName string           `position:"Path" name:"projectName"`
	InstanceId  requests.Integer `position:"Path" name:"instanceId"`
	ConfigJson  string           `position:"Body" name:"configJson"`
	JobName     string           `position:"Path" name:"jobName"`
}

// UpdateAutoScaleConfigResponse is the response struct for api UpdateAutoScaleConfig
type UpdateAutoScaleConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAutoScaleConfigRequest creates a request to invoke UpdateAutoScaleConfig API
func CreateUpdateAutoScaleConfigRequest() (request *UpdateAutoScaleConfigRequest) {
	request = &UpdateAutoScaleConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "UpdateAutoScaleConfig", "/api/v2/projects/[projectName]/jobs/[jobName]/instance/[instanceId]/autoscale/config", "foas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateAutoScaleConfigResponse creates a response to parse from UpdateAutoScaleConfig response
func CreateUpdateAutoScaleConfigResponse() (response *UpdateAutoScaleConfigResponse) {
	response = &UpdateAutoScaleConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
