package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCdiBag invokes the green.CreateCdiBag API synchronously
// api document: https://help.aliyun.com/api/green/createcdibag.html
func (client *Client) CreateCdiBag(request *CreateCdiBagRequest) (response *CreateCdiBagResponse, err error) {
	response = CreateCreateCdiBagResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCdiBagWithChan invokes the green.CreateCdiBag API asynchronously
// api document: https://help.aliyun.com/api/green/createcdibag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCdiBagWithChan(request *CreateCdiBagRequest) (<-chan *CreateCdiBagResponse, <-chan error) {
	responseChan := make(chan *CreateCdiBagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCdiBag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCdiBagWithCallback invokes the green.CreateCdiBag API asynchronously
// api document: https://help.aliyun.com/api/green/createcdibag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCdiBagWithCallback(request *CreateCdiBagRequest, callback func(response *CreateCdiBagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCdiBagResponse
		var err error
		defer close(result)
		response, err = client.CreateCdiBag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCdiBagRequest is the request struct for api CreateCdiBag
type CreateCdiBagRequest struct {
	*requests.RpcRequest
	ClientToken   string           `position:"Query" name:"ClientToken"`
	OrderNum      requests.Integer `position:"Query" name:"OrderNum"`
	CommodityCode string           `position:"Query" name:"CommodityCode"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	FlowOutSpec   requests.Integer `position:"Query" name:"FlowOutSpec"`
	OrderType     string           `position:"Query" name:"OrderType"`
}

// CreateCdiBagResponse is the response struct for api CreateCdiBag
type CreateCdiBagResponse struct {
	*responses.BaseResponse
	Code        string                    `json:"Code" xml:"Code"`
	Message     string                    `json:"Message" xml:"Message"`
	OrderId     string                    `json:"OrderId" xml:"OrderId"`
	RequestId   string                    `json:"RequestId" xml:"RequestId"`
	InstanceIds InstanceIdsInCreateCdiBag `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateCreateCdiBagRequest creates a request to invoke CreateCdiBag API
func CreateCreateCdiBagRequest() (request *CreateCdiBagRequest) {
	request = &CreateCdiBagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "CreateCdiBag", "green", "openAPI")
	return
}

// CreateCreateCdiBagResponse creates a response to parse from CreateCdiBag response
func CreateCreateCdiBagResponse() (response *CreateCdiBagResponse) {
	response = &CreateCdiBagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
