package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWebSiteInstance invokes the green.CreateWebSiteInstance API synchronously
// api document: https://help.aliyun.com/api/green/createwebsiteinstance.html
func (client *Client) CreateWebSiteInstance(request *CreateWebSiteInstanceRequest) (response *CreateWebSiteInstanceResponse, err error) {
	response = CreateCreateWebSiteInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWebSiteInstanceWithChan invokes the green.CreateWebSiteInstance API asynchronously
// api document: https://help.aliyun.com/api/green/createwebsiteinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateWebSiteInstanceWithChan(request *CreateWebSiteInstanceRequest) (<-chan *CreateWebSiteInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateWebSiteInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWebSiteInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWebSiteInstanceWithCallback invokes the green.CreateWebSiteInstance API asynchronously
// api document: https://help.aliyun.com/api/green/createwebsiteinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateWebSiteInstanceWithCallback(request *CreateWebSiteInstanceRequest, callback func(response *CreateWebSiteInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWebSiteInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateWebSiteInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWebSiteInstanceRequest is the request struct for api CreateWebSiteInstance
type CreateWebSiteInstanceRequest struct {
	*requests.RpcRequest
	Duration     requests.Integer `position:"Query" name:"Duration"`
	ClientToken  string           `position:"Query" name:"ClientToken"`
	OrderNum     requests.Integer `position:"Query" name:"OrderNum"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	PricingCycle string           `position:"Query" name:"PricingCycle"`
	OrderType    string           `position:"Query" name:"OrderType"`
}

// CreateWebSiteInstanceResponse is the response struct for api CreateWebSiteInstance
type CreateWebSiteInstanceResponse struct {
	*responses.BaseResponse
	Code        string                             `json:"Code" xml:"Code"`
	Message     string                             `json:"Message" xml:"Message"`
	OrderId     string                             `json:"OrderId" xml:"OrderId"`
	RequestId   string                             `json:"RequestId" xml:"RequestId"`
	InstanceIds InstanceIdsInCreateWebSiteInstance `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateCreateWebSiteInstanceRequest creates a request to invoke CreateWebSiteInstance API
func CreateCreateWebSiteInstanceRequest() (request *CreateWebSiteInstanceRequest) {
	request = &CreateWebSiteInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "CreateWebSiteInstance", "green", "openAPI")
	return
}

// CreateCreateWebSiteInstanceResponse creates a response to parse from CreateWebSiteInstance response
func CreateCreateWebSiteInstanceResponse() (response *CreateWebSiteInstanceResponse) {
	response = &CreateWebSiteInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
