package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebsiteVerifyInfo invokes the green.DescribeWebsiteVerifyInfo API synchronously
// api document: https://help.aliyun.com/api/green/describewebsiteverifyinfo.html
func (client *Client) DescribeWebsiteVerifyInfo(request *DescribeWebsiteVerifyInfoRequest) (response *DescribeWebsiteVerifyInfoResponse, err error) {
	response = CreateDescribeWebsiteVerifyInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebsiteVerifyInfoWithChan invokes the green.DescribeWebsiteVerifyInfo API asynchronously
// api document: https://help.aliyun.com/api/green/describewebsiteverifyinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebsiteVerifyInfoWithChan(request *DescribeWebsiteVerifyInfoRequest) (<-chan *DescribeWebsiteVerifyInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeWebsiteVerifyInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebsiteVerifyInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebsiteVerifyInfoWithCallback invokes the green.DescribeWebsiteVerifyInfo API asynchronously
// api document: https://help.aliyun.com/api/green/describewebsiteverifyinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebsiteVerifyInfoWithCallback(request *DescribeWebsiteVerifyInfoRequest, callback func(response *DescribeWebsiteVerifyInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebsiteVerifyInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebsiteVerifyInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebsiteVerifyInfoRequest is the request struct for api DescribeWebsiteVerifyInfo
type DescribeWebsiteVerifyInfoRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribeWebsiteVerifyInfoResponse is the response struct for api DescribeWebsiteVerifyInfo
type DescribeWebsiteVerifyInfoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Cname        string `json:"Cname" xml:"Cname"`
	HostFile     string `json:"HostFile" xml:"HostFile"`
	IndexPage    string `json:"IndexPage" xml:"IndexPage"`
	Domain       string `json:"Domain" xml:"Domain"`
	VerifyMethod string `json:"VerifyMethod" xml:"VerifyMethod"`
	Protocol     string `json:"Protocol" xml:"Protocol"`
}

// CreateDescribeWebsiteVerifyInfoRequest creates a request to invoke DescribeWebsiteVerifyInfo API
func CreateDescribeWebsiteVerifyInfoRequest() (request *DescribeWebsiteVerifyInfoRequest) {
	request = &DescribeWebsiteVerifyInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeWebsiteVerifyInfo", "green", "openAPI")
	return
}

// CreateDescribeWebsiteVerifyInfoResponse creates a response to parse from DescribeWebsiteVerifyInfo response
func CreateDescribeWebsiteVerifyInfoResponse() (response *DescribeWebsiteVerifyInfoResponse) {
	response = &DescribeWebsiteVerifyInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
