package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSimilarityLibraries invokes the green.ListSimilarityLibraries API synchronously
// api document: https://help.aliyun.com/api/green/listsimilaritylibraries.html
func (client *Client) ListSimilarityLibraries(request *ListSimilarityLibrariesRequest) (response *ListSimilarityLibrariesResponse, err error) {
	response = CreateListSimilarityLibrariesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSimilarityLibrariesWithChan invokes the green.ListSimilarityLibraries API asynchronously
// api document: https://help.aliyun.com/api/green/listsimilaritylibraries.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSimilarityLibrariesWithChan(request *ListSimilarityLibrariesRequest) (<-chan *ListSimilarityLibrariesResponse, <-chan error) {
	responseChan := make(chan *ListSimilarityLibrariesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSimilarityLibraries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSimilarityLibrariesWithCallback invokes the green.ListSimilarityLibraries API asynchronously
// api document: https://help.aliyun.com/api/green/listsimilaritylibraries.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSimilarityLibrariesWithCallback(request *ListSimilarityLibrariesRequest, callback func(response *ListSimilarityLibrariesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSimilarityLibrariesResponse
		var err error
		defer close(result)
		response, err = client.ListSimilarityLibraries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSimilarityLibrariesRequest is the request struct for api ListSimilarityLibraries
type ListSimilarityLibrariesRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// ListSimilarityLibrariesResponse is the response struct for api ListSimilarityLibraries
type ListSimilarityLibrariesResponse struct {
	*responses.BaseResponse
}

// CreateListSimilarityLibrariesRequest creates a request to invoke ListSimilarityLibraries API
func CreateListSimilarityLibrariesRequest() (request *ListSimilarityLibrariesRequest) {
	request = &ListSimilarityLibrariesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "ListSimilarityLibraries", "/green/similarity/library/list", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSimilarityLibrariesResponse creates a response to parse from ListSimilarityLibraries response
func CreateListSimilarityLibrariesResponse() (response *ListSimilarityLibrariesResponse) {
	response = &ListSimilarityLibrariesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
