package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefundCdiBaseBag invokes the green.RefundCdiBaseBag API synchronously
// api document: https://help.aliyun.com/api/green/refundcdibasebag.html
func (client *Client) RefundCdiBaseBag(request *RefundCdiBaseBagRequest) (response *RefundCdiBaseBagResponse, err error) {
	response = CreateRefundCdiBaseBagResponse()
	err = client.DoAction(request, response)
	return
}

// RefundCdiBaseBagWithChan invokes the green.RefundCdiBaseBag API asynchronously
// api document: https://help.aliyun.com/api/green/refundcdibasebag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RefundCdiBaseBagWithChan(request *RefundCdiBaseBagRequest) (<-chan *RefundCdiBaseBagResponse, <-chan error) {
	responseChan := make(chan *RefundCdiBaseBagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefundCdiBaseBag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefundCdiBaseBagWithCallback invokes the green.RefundCdiBaseBag API asynchronously
// api document: https://help.aliyun.com/api/green/refundcdibasebag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RefundCdiBaseBagWithCallback(request *RefundCdiBaseBagRequest, callback func(response *RefundCdiBaseBagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefundCdiBaseBagResponse
		var err error
		defer close(result)
		response, err = client.RefundCdiBaseBag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefundCdiBaseBagRequest is the request struct for api RefundCdiBaseBag
type RefundCdiBaseBagRequest struct {
	*requests.RpcRequest
	ResourceOwnerId string `position:"Query" name:"ResourceOwnerId"`
	InstanceId      string `position:"Query" name:"InstanceId"`
}

// RefundCdiBaseBagResponse is the response struct for api RefundCdiBaseBag
type RefundCdiBaseBagResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRefundCdiBaseBagRequest creates a request to invoke RefundCdiBaseBag API
func CreateRefundCdiBaseBagRequest() (request *RefundCdiBaseBagRequest) {
	request = &RefundCdiBaseBagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "RefundCdiBaseBag", "green", "openAPI")
	return
}

// CreateRefundCdiBaseBagResponse creates a response to parse from RefundCdiBaseBag response
func CreateRefundCdiBaseBagResponse() (response *RefundCdiBaseBagResponse) {
	response = &RefundCdiBaseBagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
