package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendVerifyCodeToPhone invokes the green.SendVerifyCodeToPhone API synchronously
// api document: https://help.aliyun.com/api/green/sendverifycodetophone.html
func (client *Client) SendVerifyCodeToPhone(request *SendVerifyCodeToPhoneRequest) (response *SendVerifyCodeToPhoneResponse, err error) {
	response = CreateSendVerifyCodeToPhoneResponse()
	err = client.DoAction(request, response)
	return
}

// SendVerifyCodeToPhoneWithChan invokes the green.SendVerifyCodeToPhone API asynchronously
// api document: https://help.aliyun.com/api/green/sendverifycodetophone.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendVerifyCodeToPhoneWithChan(request *SendVerifyCodeToPhoneRequest) (<-chan *SendVerifyCodeToPhoneResponse, <-chan error) {
	responseChan := make(chan *SendVerifyCodeToPhoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendVerifyCodeToPhone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendVerifyCodeToPhoneWithCallback invokes the green.SendVerifyCodeToPhone API asynchronously
// api document: https://help.aliyun.com/api/green/sendverifycodetophone.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendVerifyCodeToPhoneWithCallback(request *SendVerifyCodeToPhoneRequest, callback func(response *SendVerifyCodeToPhoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendVerifyCodeToPhoneResponse
		var err error
		defer close(result)
		response, err = client.SendVerifyCodeToPhone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendVerifyCodeToPhoneRequest is the request struct for api SendVerifyCodeToPhone
type SendVerifyCodeToPhoneRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Phone    string `position:"Query" name:"Phone"`
	Lang     string `position:"Query" name:"Lang"`
}

// SendVerifyCodeToPhoneResponse is the response struct for api SendVerifyCodeToPhone
type SendVerifyCodeToPhoneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSendVerifyCodeToPhoneRequest creates a request to invoke SendVerifyCodeToPhone API
func CreateSendVerifyCodeToPhoneRequest() (request *SendVerifyCodeToPhoneRequest) {
	request = &SendVerifyCodeToPhoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "SendVerifyCodeToPhone", "green", "openAPI")
	return
}

// CreateSendVerifyCodeToPhoneResponse creates a response to parse from SendVerifyCodeToPhone response
func CreateSendVerifyCodeToPhoneResponse() (response *SendVerifyCodeToPhoneResponse) {
	response = &SendVerifyCodeToPhoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
