package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendWebsiteFeedback invokes the green.SendWebsiteFeedback API synchronously
// api document: https://help.aliyun.com/api/green/sendwebsitefeedback.html
func (client *Client) SendWebsiteFeedback(request *SendWebsiteFeedbackRequest) (response *SendWebsiteFeedbackResponse, err error) {
	response = CreateSendWebsiteFeedbackResponse()
	err = client.DoAction(request, response)
	return
}

// SendWebsiteFeedbackWithChan invokes the green.SendWebsiteFeedback API asynchronously
// api document: https://help.aliyun.com/api/green/sendwebsitefeedback.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendWebsiteFeedbackWithChan(request *SendWebsiteFeedbackRequest) (<-chan *SendWebsiteFeedbackResponse, <-chan error) {
	responseChan := make(chan *SendWebsiteFeedbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendWebsiteFeedback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendWebsiteFeedbackWithCallback invokes the green.SendWebsiteFeedback API asynchronously
// api document: https://help.aliyun.com/api/green/sendwebsitefeedback.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendWebsiteFeedbackWithCallback(request *SendWebsiteFeedbackRequest, callback func(response *SendWebsiteFeedbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendWebsiteFeedbackResponse
		var err error
		defer close(result)
		response, err = client.SendWebsiteFeedback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendWebsiteFeedbackRequest is the request struct for api SendWebsiteFeedback
type SendWebsiteFeedbackRequest struct {
	*requests.RpcRequest
	Feedback string `position:"Query" name:"Feedback"`
	Urls     string `position:"Query" name:"Urls"`
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// SendWebsiteFeedbackResponse is the response struct for api SendWebsiteFeedback
type SendWebsiteFeedbackResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSendWebsiteFeedbackRequest creates a request to invoke SendWebsiteFeedback API
func CreateSendWebsiteFeedbackRequest() (request *SendWebsiteFeedbackRequest) {
	request = &SendWebsiteFeedbackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "SendWebsiteFeedback", "green", "openAPI")
	return
}

// CreateSendWebsiteFeedbackResponse creates a response to parse from SendWebsiteFeedback response
func CreateSendWebsiteFeedbackResponse() (response *SendWebsiteFeedbackResponse) {
	response = &SendWebsiteFeedbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
