package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TextKeywordFilter invokes the green.TextKeywordFilter API synchronously
// api document: https://help.aliyun.com/api/green/textkeywordfilter.html
func (client *Client) TextKeywordFilter(request *TextKeywordFilterRequest) (response *TextKeywordFilterResponse, err error) {
	response = CreateTextKeywordFilterResponse()
	err = client.DoAction(request, response)
	return
}

// TextKeywordFilterWithChan invokes the green.TextKeywordFilter API asynchronously
// api document: https://help.aliyun.com/api/green/textkeywordfilter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TextKeywordFilterWithChan(request *TextKeywordFilterRequest) (<-chan *TextKeywordFilterResponse, <-chan error) {
	responseChan := make(chan *TextKeywordFilterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TextKeywordFilter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TextKeywordFilterWithCallback invokes the green.TextKeywordFilter API asynchronously
// api document: https://help.aliyun.com/api/green/textkeywordfilter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TextKeywordFilterWithCallback(request *TextKeywordFilterRequest, callback func(response *TextKeywordFilterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TextKeywordFilterResponse
		var err error
		defer close(result)
		response, err = client.TextKeywordFilter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TextKeywordFilterRequest is the request struct for api TextKeywordFilter
type TextKeywordFilterRequest struct {
	*requests.RoaRequest
}

// TextKeywordFilterResponse is the response struct for api TextKeywordFilter
type TextKeywordFilterResponse struct {
	*responses.BaseResponse
}

// CreateTextKeywordFilterRequest creates a request to invoke TextKeywordFilter API
func CreateTextKeywordFilterRequest() (request *TextKeywordFilterRequest) {
	request = &TextKeywordFilterRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2016-12-22", "TextKeywordFilter", "/text/keyword_filter", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTextKeywordFilterResponse creates a response to parse from TextKeywordFilter response
func CreateTextKeywordFilterResponse() (response *TextKeywordFilterResponse) {
	response = &TextKeywordFilterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
