package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyPhone invokes the green.VerifyPhone API synchronously
// api document: https://help.aliyun.com/api/green/verifyphone.html
func (client *Client) VerifyPhone(request *VerifyPhoneRequest) (response *VerifyPhoneResponse, err error) {
	response = CreateVerifyPhoneResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyPhoneWithChan invokes the green.VerifyPhone API asynchronously
// api document: https://help.aliyun.com/api/green/verifyphone.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifyPhoneWithChan(request *VerifyPhoneRequest) (<-chan *VerifyPhoneResponse, <-chan error) {
	responseChan := make(chan *VerifyPhoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyPhone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyPhoneWithCallback invokes the green.VerifyPhone API asynchronously
// api document: https://help.aliyun.com/api/green/verifyphone.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifyPhoneWithCallback(request *VerifyPhoneRequest, callback func(response *VerifyPhoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyPhoneResponse
		var err error
		defer close(result)
		response, err = client.VerifyPhone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyPhoneRequest is the request struct for api VerifyPhone
type VerifyPhoneRequest struct {
	*requests.RpcRequest
	VerifyCode string `position:"Query" name:"VerifyCode"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Phone      string `position:"Query" name:"Phone"`
	Lang       string `position:"Query" name:"Lang"`
}

// VerifyPhoneResponse is the response struct for api VerifyPhone
type VerifyPhoneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateVerifyPhoneRequest creates a request to invoke VerifyPhone API
func CreateVerifyPhoneRequest() (request *VerifyPhoneRequest) {
	request = &VerifyPhoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "VerifyPhone", "green", "openAPI")
	return
}

// CreateVerifyPhoneResponse creates a response to parse from VerifyPhone response
func CreateVerifyPhoneResponse() (response *VerifyPhoneResponse) {
	response = &VerifyPhoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
