package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConvertInstance invokes the hbase.ConvertInstance API synchronously
// api document: https://help.aliyun.com/api/hbase/convertinstance.html
func (client *Client) ConvertInstance(request *ConvertInstanceRequest) (response *ConvertInstanceResponse, err error) {
	response = CreateConvertInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ConvertInstanceWithChan invokes the hbase.ConvertInstance API asynchronously
// api document: https://help.aliyun.com/api/hbase/convertinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConvertInstanceWithChan(request *ConvertInstanceRequest) (<-chan *ConvertInstanceResponse, <-chan error) {
	responseChan := make(chan *ConvertInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConvertInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConvertInstanceWithCallback invokes the hbase.ConvertInstance API asynchronously
// api document: https://help.aliyun.com/api/hbase/convertinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConvertInstanceWithCallback(request *ConvertInstanceRequest, callback func(response *ConvertInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConvertInstanceResponse
		var err error
		defer close(result)
		response, err = client.ConvertInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConvertInstanceRequest is the request struct for api ConvertInstance
type ConvertInstanceRequest struct {
	*requests.RpcRequest
	ClusterId    string           `position:"Query" name:"ClusterId"`
	Duration     requests.Integer `position:"Query" name:"Duration"`
	PricingCycle string           `position:"Query" name:"PricingCycle"`
}

// ConvertInstanceResponse is the response struct for api ConvertInstance
type ConvertInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   int64  `json:"OrderId" xml:"OrderId"`
}

// CreateConvertInstanceRequest creates a request to invoke ConvertInstance API
func CreateConvertInstanceRequest() (request *ConvertInstanceRequest) {
	request = &ConvertInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ConvertInstance", "hbase", "openAPI")
	return
}

// CreateConvertInstanceResponse creates a response to parse from ConvertInstance response
func CreateConvertInstanceResponse() (response *ConvertInstanceResponse) {
	response = &ConvertInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
