package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstance invokes the hbase.CreateInstance API synchronously
// api document: https://help.aliyun.com/api/hbase/createinstance.html
func (client *Client) CreateInstance(request *CreateInstanceRequest) (response *CreateInstanceResponse, err error) {
	response = CreateCreateInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceWithChan invokes the hbase.CreateInstance API asynchronously
// api document: https://help.aliyun.com/api/hbase/createinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceWithChan(request *CreateInstanceRequest) (<-chan *CreateInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceWithCallback invokes the hbase.CreateInstance API asynchronously
// api document: https://help.aliyun.com/api/hbase/createinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceWithCallback(request *CreateInstanceRequest, callback func(response *CreateInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceRequest is the request struct for api CreateInstance
type CreateInstanceRequest struct {
	*requests.RpcRequest
	ClusterName          string `position:"Query" name:"ClusterName"`
	DbInstanceConnType   string `position:"Query" name:"DbInstanceConnType"`
	EngineVersion        string `position:"Query" name:"EngineVersion"`
	DepMode              string `position:"Query" name:"DepMode"`
	BackupId             string `position:"Query" name:"BackupId"`
	DbInstanceType       string `position:"Query" name:"DbInstanceType"`
	VSwitchId            string `position:"Query" name:"VSwitchId"`
	SecurityIPList       string `position:"Query" name:"SecurityIPList"`
	AutoRenew            string `position:"Query" name:"AutoRenew"`
	NetType              string `position:"Query" name:"NetType"`
	ZoneId               string `position:"Query" name:"ZoneId"`
	CoreDiskType         string `position:"Query" name:"CoreDiskType"`
	PricingCycle         string `position:"Query" name:"PricingCycle"`
	CoreInstanceQuantity string `position:"Query" name:"CoreInstanceQuantity"`
	Duration             string `position:"Query" name:"Duration"`
	Engine               string `position:"Query" name:"Engine"`
	RestoreTime          string `position:"Query" name:"RestoreTime"`
	SrcDBInstanceId      string `position:"Query" name:"SrcDBInstanceId"`
	MasterInstanceType   string `position:"Query" name:"MasterInstanceType"`
	ColdStorageSize      string `position:"Query" name:"ColdStorageSize"`
	CoreDiskQuantity     string `position:"Query" name:"CoreDiskQuantity"`
	IsColdStorage        string `position:"Query" name:"IsColdStorage"`
	CoreInstanceType     string `position:"Query" name:"CoreInstanceType"`
	CoreDiskSize         string `position:"Query" name:"CoreDiskSize"`
	VpcId                string `position:"Query" name:"VpcId"`
	DbType               string `position:"Query" name:"DbType"`
	PayType              string `position:"Query" name:"PayType"`
}

// CreateInstanceResponse is the response struct for api CreateInstance
type CreateInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ClusterId string `json:"ClusterId" xml:"ClusterId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateCreateInstanceRequest creates a request to invoke CreateInstance API
func CreateCreateInstanceRequest() (request *CreateInstanceRequest) {
	request = &CreateInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "CreateInstance", "hbase", "openAPI")
	return
}

// CreateCreateInstanceResponse creates a response to parse from CreateInstance response
func CreateCreateInstanceResponse() (response *CreateInstanceResponse) {
	response = &CreateInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
