package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExtendImageStyle invokes the imageenhan.ExtendImageStyle API synchronously
// api document: https://help.aliyun.com/api/imageenhan/extendimagestyle.html
func (client *Client) ExtendImageStyle(request *ExtendImageStyleRequest) (response *ExtendImageStyleResponse, err error) {
	response = CreateExtendImageStyleResponse()
	err = client.DoAction(request, response)
	return
}

// ExtendImageStyleWithChan invokes the imageenhan.ExtendImageStyle API asynchronously
// api document: https://help.aliyun.com/api/imageenhan/extendimagestyle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExtendImageStyleWithChan(request *ExtendImageStyleRequest) (<-chan *ExtendImageStyleResponse, <-chan error) {
	responseChan := make(chan *ExtendImageStyleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExtendImageStyle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExtendImageStyleWithCallback invokes the imageenhan.ExtendImageStyle API asynchronously
// api document: https://help.aliyun.com/api/imageenhan/extendimagestyle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExtendImageStyleWithCallback(request *ExtendImageStyleRequest, callback func(response *ExtendImageStyleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExtendImageStyleResponse
		var err error
		defer close(result)
		response, err = client.ExtendImageStyle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExtendImageStyleRequest is the request struct for api ExtendImageStyle
type ExtendImageStyleRequest struct {
	*requests.RpcRequest
	MajorUrl string `position:"Body" name:"MajorUrl"`
	StyleUrl string `position:"Body" name:"StyleUrl"`
}

// ExtendImageStyleResponse is the response struct for api ExtendImageStyle
type ExtendImageStyleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateExtendImageStyleRequest creates a request to invoke ExtendImageStyle API
func CreateExtendImageStyleRequest() (request *ExtendImageStyleRequest) {
	request = &ExtendImageStyleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "ExtendImageStyle", "imageenhan", "openAPI")
	return
}

// CreateExtendImageStyleResponse creates a response to parse from ExtendImageStyle response
func CreateExtendImageStyleResponse() (response *ExtendImageStyleResponse) {
	response = &ExtendImageStyleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
