package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectClothes invokes the imm.DetectClothes API synchronously
// api document: https://help.aliyun.com/api/imm/detectclothes.html
func (client *Client) DetectClothes(request *DetectClothesRequest) (response *DetectClothesResponse, err error) {
	response = CreateDetectClothesResponse()
	err = client.DoAction(request, response)
	return
}

// DetectClothesWithChan invokes the imm.DetectClothes API asynchronously
// api document: https://help.aliyun.com/api/imm/detectclothes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetectClothesWithChan(request *DetectClothesRequest) (<-chan *DetectClothesResponse, <-chan error) {
	responseChan := make(chan *DetectClothesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectClothes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectClothesWithCallback invokes the imm.DetectClothes API asynchronously
// api document: https://help.aliyun.com/api/imm/detectclothes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetectClothesWithCallback(request *DetectClothesRequest, callback func(response *DetectClothesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectClothesResponse
		var err error
		defer close(result)
		response, err = client.DetectClothes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectClothesRequest is the request struct for api DetectClothes
type DetectClothesRequest struct {
	*requests.RpcRequest
	Project string `position:"Query" name:"Project"`
	SrcUris string `position:"Query" name:"SrcUris"`
}

// DetectClothesResponse is the response struct for api DetectClothes
type DetectClothesResponse struct {
	*responses.BaseResponse
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	SrcUris        []string             `json:"SrcUris" xml:"SrcUris"`
	SuccessDetails []SuccessDetailsItem `json:"SuccessDetails" xml:"SuccessDetails"`
	FailDetails    []FailDetailsItem    `json:"FailDetails" xml:"FailDetails"`
}

// CreateDetectClothesRequest creates a request to invoke DetectClothes API
func CreateDetectClothesRequest() (request *DetectClothesRequest) {
	request = &DetectClothesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DetectClothes", "imm", "openAPI")
	return
}

// CreateDetectClothesResponse creates a response to parse from DetectClothes response
func CreateDetectClothesResponse() (response *DetectClothesResponse) {
	response = &DetectClothesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
