package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProductMetaListByName invokes the iot.GetProductMetaListByName API synchronously
// api document: https://help.aliyun.com/api/iot/getproductmetalistbyname.html
func (client *Client) GetProductMetaListByName(request *GetProductMetaListByNameRequest) (response *GetProductMetaListByNameResponse, err error) {
	response = CreateGetProductMetaListByNameResponse()
	err = client.DoAction(request, response)
	return
}

// GetProductMetaListByNameWithChan invokes the iot.GetProductMetaListByName API asynchronously
// api document: https://help.aliyun.com/api/iot/getproductmetalistbyname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProductMetaListByNameWithChan(request *GetProductMetaListByNameRequest) (<-chan *GetProductMetaListByNameResponse, <-chan error) {
	responseChan := make(chan *GetProductMetaListByNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProductMetaListByName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProductMetaListByNameWithCallback invokes the iot.GetProductMetaListByName API asynchronously
// api document: https://help.aliyun.com/api/iot/getproductmetalistbyname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProductMetaListByNameWithCallback(request *GetProductMetaListByNameRequest, callback func(response *GetProductMetaListByNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProductMetaListByNameResponse
		var err error
		defer close(result)
		response, err = client.GetProductMetaListByName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProductMetaListByNameRequest is the request struct for api GetProductMetaListByName
type GetProductMetaListByNameRequest struct {
	*requests.RpcRequest
	ProductKey      string `position:"Body" name:"ProductKey"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	IotInstanceId   string `position:"Query" name:"IotInstanceId"`
	DeviceName      string `position:"Body" name:"DeviceName"`
	Page            string `position:"Body" name:"Page"`
}

// GetProductMetaListByNameResponse is the response struct for api GetProductMetaListByName
type GetProductMetaListByNameResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateGetProductMetaListByNameRequest creates a request to invoke GetProductMetaListByName API
func CreateGetProductMetaListByNameRequest() (request *GetProductMetaListByNameRequest) {
	request = &GetProductMetaListByNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetProductMetaListByName", "iot", "openAPI")
	return
}

// CreateGetProductMetaListByNameResponse creates a response to parse from GetProductMetaListByName response
func CreateGetProductMetaListByNameResponse() (response *GetProductMetaListByNameResponse) {
	response = &GetProductMetaListByNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
