package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteStreamPredict invokes the ivision.DeleteStreamPredict API synchronously
// api document: https://help.aliyun.com/api/ivision/deletestreampredict.html
func (client *Client) DeleteStreamPredict(request *DeleteStreamPredictRequest) (response *DeleteStreamPredictResponse, err error) {
	response = CreateDeleteStreamPredictResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteStreamPredictWithChan invokes the ivision.DeleteStreamPredict API asynchronously
// api document: https://help.aliyun.com/api/ivision/deletestreampredict.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteStreamPredictWithChan(request *DeleteStreamPredictRequest) (<-chan *DeleteStreamPredictResponse, <-chan error) {
	responseChan := make(chan *DeleteStreamPredictResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteStreamPredict(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteStreamPredictWithCallback invokes the ivision.DeleteStreamPredict API asynchronously
// api document: https://help.aliyun.com/api/ivision/deletestreampredict.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteStreamPredictWithCallback(request *DeleteStreamPredictRequest, callback func(response *DeleteStreamPredictResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteStreamPredictResponse
		var err error
		defer close(result)
		response, err = client.DeleteStreamPredict(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteStreamPredictRequest is the request struct for api DeleteStreamPredict
type DeleteStreamPredictRequest struct {
	*requests.RpcRequest
	PredictId string           `position:"Query" name:"PredictId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteStreamPredictResponse is the response struct for api DeleteStreamPredict
type DeleteStreamPredictResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	PredictId string `json:"PredictId" xml:"PredictId"`
}

// CreateDeleteStreamPredictRequest creates a request to invoke DeleteStreamPredict API
func CreateDeleteStreamPredictRequest() (request *DeleteStreamPredictRequest) {
	request = &DeleteStreamPredictRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DeleteStreamPredict", "ivision", "openAPI")
	return
}

// CreateDeleteStreamPredictResponse creates a response to parse from DeleteStreamPredict response
func CreateDeleteStreamPredictResponse() (response *DeleteStreamPredictResponse) {
	response = &DeleteStreamPredictResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
