package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnregisterFace invokes the ivision.UnregisterFace API synchronously
// api document: https://help.aliyun.com/api/ivision/unregisterface.html
func (client *Client) UnregisterFace(request *UnregisterFaceRequest) (response *UnregisterFaceResponse, err error) {
	response = CreateUnregisterFaceResponse()
	err = client.DoAction(request, response)
	return
}

// UnregisterFaceWithChan invokes the ivision.UnregisterFace API asynchronously
// api document: https://help.aliyun.com/api/ivision/unregisterface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnregisterFaceWithChan(request *UnregisterFaceRequest) (<-chan *UnregisterFaceResponse, <-chan error) {
	responseChan := make(chan *UnregisterFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnregisterFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnregisterFaceWithCallback invokes the ivision.UnregisterFace API asynchronously
// api document: https://help.aliyun.com/api/ivision/unregisterface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnregisterFaceWithCallback(request *UnregisterFaceRequest, callback func(response *UnregisterFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnregisterFaceResponse
		var err error
		defer close(result)
		response, err = client.UnregisterFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnregisterFaceRequest is the request struct for api UnregisterFace
type UnregisterFaceRequest struct {
	*requests.RpcRequest
	ShowLog   string           `position:"Query" name:"ShowLog"`
	GroupId   string           `position:"Query" name:"GroupId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	FaceToken string           `position:"Query" name:"FaceToken"`
}

// UnregisterFaceResponse is the response struct for api UnregisterFace
type UnregisterFaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	GroupId   string `json:"GroupId" xml:"GroupId"`
	FaceToken string `json:"FaceToken" xml:"FaceToken"`
}

// CreateUnregisterFaceRequest creates a request to invoke UnregisterFace API
func CreateUnregisterFaceRequest() (request *UnregisterFaceRequest) {
	request = &UnregisterFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "UnregisterFace", "ivision", "openAPI")
	return
}

// CreateUnregisterFaceResponse creates a response to parse from UnregisterFace response
func CreateUnregisterFaceResponse() (response *UnregisterFaceResponse) {
	response = &UnregisterFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
