package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveSnapshotDetectPornConfig invokes the live.DeleteLiveSnapshotDetectPornConfig API synchronously
// api document: https://help.aliyun.com/api/live/deletelivesnapshotdetectpornconfig.html
func (client *Client) DeleteLiveSnapshotDetectPornConfig(request *DeleteLiveSnapshotDetectPornConfigRequest) (response *DeleteLiveSnapshotDetectPornConfigResponse, err error) {
	response = CreateDeleteLiveSnapshotDetectPornConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveSnapshotDetectPornConfigWithChan invokes the live.DeleteLiveSnapshotDetectPornConfig API asynchronously
// api document: https://help.aliyun.com/api/live/deletelivesnapshotdetectpornconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveSnapshotDetectPornConfigWithChan(request *DeleteLiveSnapshotDetectPornConfigRequest) (<-chan *DeleteLiveSnapshotDetectPornConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveSnapshotDetectPornConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveSnapshotDetectPornConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveSnapshotDetectPornConfigWithCallback invokes the live.DeleteLiveSnapshotDetectPornConfig API asynchronously
// api document: https://help.aliyun.com/api/live/deletelivesnapshotdetectpornconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveSnapshotDetectPornConfigWithCallback(request *DeleteLiveSnapshotDetectPornConfigRequest, callback func(response *DeleteLiveSnapshotDetectPornConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveSnapshotDetectPornConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveSnapshotDetectPornConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveSnapshotDetectPornConfigRequest is the request struct for api DeleteLiveSnapshotDetectPornConfig
type DeleteLiveSnapshotDetectPornConfigRequest struct {
	*requests.RpcRequest
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	AppName       string           `position:"Query" name:"AppName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DeleteLiveSnapshotDetectPornConfigResponse is the response struct for api DeleteLiveSnapshotDetectPornConfig
type DeleteLiveSnapshotDetectPornConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveSnapshotDetectPornConfigRequest creates a request to invoke DeleteLiveSnapshotDetectPornConfig API
func CreateDeleteLiveSnapshotDetectPornConfigRequest() (request *DeleteLiveSnapshotDetectPornConfigRequest) {
	request = &DeleteLiveSnapshotDetectPornConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveSnapshotDetectPornConfig", "live", "openAPI")
	return
}

// CreateDeleteLiveSnapshotDetectPornConfigResponse creates a response to parse from DeleteLiveSnapshotDetectPornConfig response
func CreateDeleteLiveSnapshotDetectPornConfigResponse() (response *DeleteLiveSnapshotDetectPornConfigResponse) {
	response = &DeleteLiveSnapshotDetectPornConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
