package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDetectPornData invokes the live.DescribeLiveDetectPornData API synchronously
// api document: https://help.aliyun.com/api/live/describelivedetectporndata.html
func (client *Client) DescribeLiveDetectPornData(request *DescribeLiveDetectPornDataRequest) (response *DescribeLiveDetectPornDataResponse, err error) {
	response = CreateDescribeLiveDetectPornDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDetectPornDataWithChan invokes the live.DescribeLiveDetectPornData API asynchronously
// api document: https://help.aliyun.com/api/live/describelivedetectporndata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveDetectPornDataWithChan(request *DescribeLiveDetectPornDataRequest) (<-chan *DescribeLiveDetectPornDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDetectPornDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDetectPornData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDetectPornDataWithCallback invokes the live.DescribeLiveDetectPornData API asynchronously
// api document: https://help.aliyun.com/api/live/describelivedetectporndata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveDetectPornDataWithCallback(request *DescribeLiveDetectPornDataRequest, callback func(response *DescribeLiveDetectPornDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDetectPornDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDetectPornData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDetectPornDataRequest is the request struct for api DescribeLiveDetectPornData
type DescribeLiveDetectPornDataRequest struct {
	*requests.RpcRequest
	Fee        string           `position:"Query" name:"Fee"`
	StartTime  string           `position:"Query" name:"StartTime"`
	Scene      string           `position:"Query" name:"Scene"`
	Stream     string           `position:"Query" name:"Stream"`
	SplitBy    string           `position:"Query" name:"SplitBy"`
	App        string           `position:"Query" name:"App"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Region     string           `position:"Query" name:"Region"`
}

// DescribeLiveDetectPornDataResponse is the response struct for api DescribeLiveDetectPornData
type DescribeLiveDetectPornDataResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	DetectPornData DetectPornData `json:"DetectPornData" xml:"DetectPornData"`
}

// CreateDescribeLiveDetectPornDataRequest creates a request to invoke DescribeLiveDetectPornData API
func CreateDescribeLiveDetectPornDataRequest() (request *DescribeLiveDetectPornDataRequest) {
	request = &DescribeLiveDetectPornDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDetectPornData", "live", "openAPI")
	return
}

// CreateDescribeLiveDetectPornDataResponse creates a response to parse from DescribeLiveDetectPornData response
func CreateDescribeLiveDetectPornDataResponse() (response *DescribeLiveDetectPornDataResponse) {
	response = &DescribeLiveDetectPornDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
