package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableLiveRealtimeLogDelivery invokes the live.DisableLiveRealtimeLogDelivery API synchronously
// api document: https://help.aliyun.com/api/live/disableliverealtimelogdelivery.html
func (client *Client) DisableLiveRealtimeLogDelivery(request *DisableLiveRealtimeLogDeliveryRequest) (response *DisableLiveRealtimeLogDeliveryResponse, err error) {
	response = CreateDisableLiveRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DisableLiveRealtimeLogDeliveryWithChan invokes the live.DisableLiveRealtimeLogDelivery API asynchronously
// api document: https://help.aliyun.com/api/live/disableliverealtimelogdelivery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableLiveRealtimeLogDeliveryWithChan(request *DisableLiveRealtimeLogDeliveryRequest) (<-chan *DisableLiveRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DisableLiveRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableLiveRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableLiveRealtimeLogDeliveryWithCallback invokes the live.DisableLiveRealtimeLogDelivery API asynchronously
// api document: https://help.aliyun.com/api/live/disableliverealtimelogdelivery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableLiveRealtimeLogDeliveryWithCallback(request *DisableLiveRealtimeLogDeliveryRequest, callback func(response *DisableLiveRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableLiveRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DisableLiveRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableLiveRealtimeLogDeliveryRequest is the request struct for api DisableLiveRealtimeLogDelivery
type DisableLiveRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DisableLiveRealtimeLogDeliveryResponse is the response struct for api DisableLiveRealtimeLogDelivery
type DisableLiveRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableLiveRealtimeLogDeliveryRequest creates a request to invoke DisableLiveRealtimeLogDelivery API
func CreateDisableLiveRealtimeLogDeliveryRequest() (request *DisableLiveRealtimeLogDeliveryRequest) {
	request = &DisableLiveRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DisableLiveRealtimeLogDelivery", "live", "openAPI")
	return
}

// CreateDisableLiveRealtimeLogDeliveryResponse creates a response to parse from DisableLiveRealtimeLogDelivery response
func CreateDisableLiveRealtimeLogDeliveryResponse() (response *DisableLiveRealtimeLogDeliveryResponse) {
	response = &DisableLiveRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
