package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveSnapshotDetectPornConfig invokes the live.UpdateLiveSnapshotDetectPornConfig API synchronously
// api document: https://help.aliyun.com/api/live/updatelivesnapshotdetectpornconfig.html
func (client *Client) UpdateLiveSnapshotDetectPornConfig(request *UpdateLiveSnapshotDetectPornConfigRequest) (response *UpdateLiveSnapshotDetectPornConfigResponse, err error) {
	response = CreateUpdateLiveSnapshotDetectPornConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveSnapshotDetectPornConfigWithChan invokes the live.UpdateLiveSnapshotDetectPornConfig API asynchronously
// api document: https://help.aliyun.com/api/live/updatelivesnapshotdetectpornconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateLiveSnapshotDetectPornConfigWithChan(request *UpdateLiveSnapshotDetectPornConfigRequest) (<-chan *UpdateLiveSnapshotDetectPornConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveSnapshotDetectPornConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveSnapshotDetectPornConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveSnapshotDetectPornConfigWithCallback invokes the live.UpdateLiveSnapshotDetectPornConfig API asynchronously
// api document: https://help.aliyun.com/api/live/updatelivesnapshotdetectpornconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateLiveSnapshotDetectPornConfigWithCallback(request *UpdateLiveSnapshotDetectPornConfigRequest, callback func(response *UpdateLiveSnapshotDetectPornConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveSnapshotDetectPornConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveSnapshotDetectPornConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveSnapshotDetectPornConfigRequest is the request struct for api UpdateLiveSnapshotDetectPornConfig
type UpdateLiveSnapshotDetectPornConfigRequest struct {
	*requests.RpcRequest
	OssEndpoint   string           `position:"Query" name:"OssEndpoint"`
	OssObject     string           `position:"Query" name:"OssObject"`
	Scene         *[]string        `position:"Query" name:"Scene"  type:"Repeated"`
	AppName       string           `position:"Query" name:"AppName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	OssBucket     string           `position:"Query" name:"OssBucket"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	Interval      requests.Integer `position:"Query" name:"Interval"`
}

// UpdateLiveSnapshotDetectPornConfigResponse is the response struct for api UpdateLiveSnapshotDetectPornConfig
type UpdateLiveSnapshotDetectPornConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveSnapshotDetectPornConfigRequest creates a request to invoke UpdateLiveSnapshotDetectPornConfig API
func CreateUpdateLiveSnapshotDetectPornConfigRequest() (request *UpdateLiveSnapshotDetectPornConfigRequest) {
	request = &UpdateLiveSnapshotDetectPornConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveSnapshotDetectPornConfig", "live", "openAPI")
	return
}

// CreateUpdateLiveSnapshotDetectPornConfigResponse creates a response to parse from UpdateLiveSnapshotDetectPornConfig response
func CreateUpdateLiveSnapshotDetectPornConfigResponse() (response *UpdateLiveSnapshotDetectPornConfigResponse) {
	response = &UpdateLiveSnapshotDetectPornConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
