package multimediaai

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFacePersons invokes the multimediaai.ListFacePersons API synchronously
// api document: https://help.aliyun.com/api/multimediaai/listfacepersons.html
func (client *Client) ListFacePersons(request *ListFacePersonsRequest) (response *ListFacePersonsResponse, err error) {
	response = CreateListFacePersonsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFacePersonsWithChan invokes the multimediaai.ListFacePersons API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/listfacepersons.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFacePersonsWithChan(request *ListFacePersonsRequest) (<-chan *ListFacePersonsResponse, <-chan error) {
	responseChan := make(chan *ListFacePersonsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFacePersons(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFacePersonsWithCallback invokes the multimediaai.ListFacePersons API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/listfacepersons.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFacePersonsWithCallback(request *ListFacePersonsRequest, callback func(response *ListFacePersonsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFacePersonsResponse
		var err error
		defer close(result)
		response, err = client.ListFacePersons(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFacePersonsRequest is the request struct for api ListFacePersons
type ListFacePersonsRequest struct {
	*requests.RpcRequest
	FaceGroupId    requests.Integer `position:"Query" name:"FaceGroupId"`
	FacePersonName string           `position:"Query" name:"FacePersonName"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
}

// ListFacePersonsResponse is the response struct for api ListFacePersons
type ListFacePersonsResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	PageNumber  int          `json:"PageNumber" xml:"PageNumber"`
	PageSize    int          `json:"PageSize" xml:"PageSize"`
	TotalCount  int64        `json:"TotalCount" xml:"TotalCount"`
	FacePersons []FacePerson `json:"FacePersons" xml:"FacePersons"`
}

// CreateListFacePersonsRequest creates a request to invoke ListFacePersons API
func CreateListFacePersonsRequest() (request *ListFacePersonsRequest) {
	request = &ListFacePersonsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("multimediaai", "2019-08-10", "ListFacePersons", "multimediaai", "openAPI")
	return
}

// CreateListFacePersonsResponse creates a response to parse from ListFacePersons response
func CreateListFacePersonsResponse() (response *ListFacePersonsResponse) {
	response = &ListFacePersonsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
