package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSkillGroupConfig invokes the qualitycheck.DeleteSkillGroupConfig API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/deleteskillgroupconfig.html
func (client *Client) DeleteSkillGroupConfig(request *DeleteSkillGroupConfigRequest) (response *DeleteSkillGroupConfigResponse, err error) {
	response = CreateDeleteSkillGroupConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSkillGroupConfigWithChan invokes the qualitycheck.DeleteSkillGroupConfig API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/deleteskillgroupconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSkillGroupConfigWithChan(request *DeleteSkillGroupConfigRequest) (<-chan *DeleteSkillGroupConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteSkillGroupConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSkillGroupConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSkillGroupConfigWithCallback invokes the qualitycheck.DeleteSkillGroupConfig API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/deleteskillgroupconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSkillGroupConfigWithCallback(request *DeleteSkillGroupConfigRequest, callback func(response *DeleteSkillGroupConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSkillGroupConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteSkillGroupConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSkillGroupConfigRequest is the request struct for api DeleteSkillGroupConfig
type DeleteSkillGroupConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// DeleteSkillGroupConfigResponse is the response struct for api DeleteSkillGroupConfig
type DeleteSkillGroupConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteSkillGroupConfigRequest creates a request to invoke DeleteSkillGroupConfig API
func CreateDeleteSkillGroupConfigRequest() (request *DeleteSkillGroupConfigRequest) {
	request = &DeleteSkillGroupConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "DeleteSkillGroupConfig", "", "")
	return
}

// CreateDeleteSkillGroupConfigResponse creates a response to parse from DeleteSkillGroupConfig response
func CreateDeleteSkillGroupConfigResponse() (response *DeleteSkillGroupConfigResponse) {
	response = &DeleteSkillGroupConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
