package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPocTestReport invokes the qualitycheck.GetPocTestReport API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/getpoctestreport.html
func (client *Client) GetPocTestReport(request *GetPocTestReportRequest) (response *GetPocTestReportResponse, err error) {
	response = CreateGetPocTestReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetPocTestReportWithChan invokes the qualitycheck.GetPocTestReport API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/getpoctestreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPocTestReportWithChan(request *GetPocTestReportRequest) (<-chan *GetPocTestReportResponse, <-chan error) {
	responseChan := make(chan *GetPocTestReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPocTestReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPocTestReportWithCallback invokes the qualitycheck.GetPocTestReport API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/getpoctestreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPocTestReportWithCallback(request *GetPocTestReportRequest, callback func(response *GetPocTestReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPocTestReportResponse
		var err error
		defer close(result)
		response, err = client.GetPocTestReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPocTestReportRequest is the request struct for api GetPocTestReport
type GetPocTestReportRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetPocTestReportResponse is the response struct for api GetPocTestReport
type GetPocTestReportResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Success   bool                   `json:"Success" xml:"Success"`
	Code      string                 `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	Data      DataInGetPocTestReport `json:"Data" xml:"Data"`
}

// CreateGetPocTestReportRequest creates a request to invoke GetPocTestReport API
func CreateGetPocTestReportRequest() (request *GetPocTestReportRequest) {
	request = &GetPocTestReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetPocTestReport", "", "")
	return
}

// CreateGetPocTestReportResponse creates a response to parse from GetPocTestReport response
func CreateGetPocTestReportResponse() (response *GetPocTestReportResponse) {
	response = &GetPocTestReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
