package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitAudioLabel invokes the qualitycheck.SubmitAudioLabel API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitaudiolabel.html
func (client *Client) SubmitAudioLabel(request *SubmitAudioLabelRequest) (response *SubmitAudioLabelResponse, err error) {
	response = CreateSubmitAudioLabelResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitAudioLabelWithChan invokes the qualitycheck.SubmitAudioLabel API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitaudiolabel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitAudioLabelWithChan(request *SubmitAudioLabelRequest) (<-chan *SubmitAudioLabelResponse, <-chan error) {
	responseChan := make(chan *SubmitAudioLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitAudioLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitAudioLabelWithCallback invokes the qualitycheck.SubmitAudioLabel API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitaudiolabel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitAudioLabelWithCallback(request *SubmitAudioLabelRequest, callback func(response *SubmitAudioLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitAudioLabelResponse
		var err error
		defer close(result)
		response, err = client.SubmitAudioLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitAudioLabelRequest is the request struct for api SubmitAudioLabel
type SubmitAudioLabelRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// SubmitAudioLabelResponse is the response struct for api SubmitAudioLabel
type SubmitAudioLabelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSubmitAudioLabelRequest creates a request to invoke SubmitAudioLabel API
func CreateSubmitAudioLabelRequest() (request *SubmitAudioLabelRequest) {
	request = &SubmitAudioLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "SubmitAudioLabel", "", "")
	return
}

// CreateSubmitAudioLabelResponse creates a response to parse from SubmitAudioLabel response
func CreateSubmitAudioLabelResponse() (response *SubmitAudioLabelResponse) {
	response = &SubmitAudioLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
