package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitCustomizationConfig invokes the qualitycheck.SubmitCustomizationConfig API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitcustomizationconfig.html
func (client *Client) SubmitCustomizationConfig(request *SubmitCustomizationConfigRequest) (response *SubmitCustomizationConfigResponse, err error) {
	response = CreateSubmitCustomizationConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitCustomizationConfigWithChan invokes the qualitycheck.SubmitCustomizationConfig API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitcustomizationconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitCustomizationConfigWithChan(request *SubmitCustomizationConfigRequest) (<-chan *SubmitCustomizationConfigResponse, <-chan error) {
	responseChan := make(chan *SubmitCustomizationConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitCustomizationConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitCustomizationConfigWithCallback invokes the qualitycheck.SubmitCustomizationConfig API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitcustomizationconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitCustomizationConfigWithCallback(request *SubmitCustomizationConfigRequest, callback func(response *SubmitCustomizationConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitCustomizationConfigResponse
		var err error
		defer close(result)
		response, err = client.SubmitCustomizationConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitCustomizationConfigRequest is the request struct for api SubmitCustomizationConfig
type SubmitCustomizationConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// SubmitCustomizationConfigResponse is the response struct for api SubmitCustomizationConfig
type SubmitCustomizationConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSubmitCustomizationConfigRequest creates a request to invoke SubmitCustomizationConfig API
func CreateSubmitCustomizationConfigRequest() (request *SubmitCustomizationConfigRequest) {
	request = &SubmitCustomizationConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "SubmitCustomizationConfig", "", "")
	return
}

// CreateSubmitCustomizationConfigResponse creates a response to parse from SubmitCustomizationConfig response
func CreateSubmitCustomizationConfigResponse() (response *SubmitCustomizationConfigResponse) {
	response = &SubmitCustomizationConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
