package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitModelTestTask invokes the qualitycheck.SubmitModelTestTask API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitmodeltesttask.html
func (client *Client) SubmitModelTestTask(request *SubmitModelTestTaskRequest) (response *SubmitModelTestTaskResponse, err error) {
	response = CreateSubmitModelTestTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitModelTestTaskWithChan invokes the qualitycheck.SubmitModelTestTask API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitmodeltesttask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitModelTestTaskWithChan(request *SubmitModelTestTaskRequest) (<-chan *SubmitModelTestTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitModelTestTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitModelTestTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitModelTestTaskWithCallback invokes the qualitycheck.SubmitModelTestTask API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/submitmodeltesttask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitModelTestTaskWithCallback(request *SubmitModelTestTaskRequest, callback func(response *SubmitModelTestTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitModelTestTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitModelTestTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitModelTestTaskRequest is the request struct for api SubmitModelTestTask
type SubmitModelTestTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// SubmitModelTestTaskResponse is the response struct for api SubmitModelTestTask
type SubmitModelTestTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSubmitModelTestTaskRequest creates a request to invoke SubmitModelTestTask API
func CreateSubmitModelTestTaskRequest() (request *SubmitModelTestTaskRequest) {
	request = &SubmitModelTestTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "SubmitModelTestTask", "", "")
	return
}

// CreateSubmitModelTestTaskResponse creates a response to parse from SubmitModelTestTask response
func CreateSubmitModelTestTaskResponse() (response *SubmitModelTestTaskResponse) {
	response = &SubmitModelTestTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
