package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWarningConfig invokes the qualitycheck.UpdateWarningConfig API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/updatewarningconfig.html
func (client *Client) UpdateWarningConfig(request *UpdateWarningConfigRequest) (response *UpdateWarningConfigResponse, err error) {
	response = CreateUpdateWarningConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWarningConfigWithChan invokes the qualitycheck.UpdateWarningConfig API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/updatewarningconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWarningConfigWithChan(request *UpdateWarningConfigRequest) (<-chan *UpdateWarningConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateWarningConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWarningConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWarningConfigWithCallback invokes the qualitycheck.UpdateWarningConfig API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/updatewarningconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWarningConfigWithCallback(request *UpdateWarningConfigRequest, callback func(response *UpdateWarningConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWarningConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateWarningConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWarningConfigRequest is the request struct for api UpdateWarningConfig
type UpdateWarningConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// UpdateWarningConfigResponse is the response struct for api UpdateWarningConfig
type UpdateWarningConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateWarningConfigRequest creates a request to invoke UpdateWarningConfig API
func CreateUpdateWarningConfigRequest() (request *UpdateWarningConfigRequest) {
	request = &UpdateWarningConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateWarningConfig", "", "")
	return
}

// CreateUpdateWarningConfigResponse creates a response to parse from UpdateWarningConfig response
func CreateUpdateWarningConfigResponse() (response *UpdateWarningConfigResponse) {
	response = &UpdateWarningConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
