package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadAudioDataWithRules4Pre invokes the qualitycheck.UploadAudioDataWithRules4Pre API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/uploadaudiodatawithrules4pre.html
func (client *Client) UploadAudioDataWithRules4Pre(request *UploadAudioDataWithRules4PreRequest) (response *UploadAudioDataWithRules4PreResponse, err error) {
	response = CreateUploadAudioDataWithRules4PreResponse()
	err = client.DoAction(request, response)
	return
}

// UploadAudioDataWithRules4PreWithChan invokes the qualitycheck.UploadAudioDataWithRules4Pre API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/uploadaudiodatawithrules4pre.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadAudioDataWithRules4PreWithChan(request *UploadAudioDataWithRules4PreRequest) (<-chan *UploadAudioDataWithRules4PreResponse, <-chan error) {
	responseChan := make(chan *UploadAudioDataWithRules4PreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadAudioDataWithRules4Pre(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadAudioDataWithRules4PreWithCallback invokes the qualitycheck.UploadAudioDataWithRules4Pre API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/uploadaudiodatawithrules4pre.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadAudioDataWithRules4PreWithCallback(request *UploadAudioDataWithRules4PreRequest, callback func(response *UploadAudioDataWithRules4PreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadAudioDataWithRules4PreResponse
		var err error
		defer close(result)
		response, err = client.UploadAudioDataWithRules4Pre(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadAudioDataWithRules4PreRequest is the request struct for api UploadAudioDataWithRules4Pre
type UploadAudioDataWithRules4PreRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// UploadAudioDataWithRules4PreResponse is the response struct for api UploadAudioDataWithRules4Pre
type UploadAudioDataWithRules4PreResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateUploadAudioDataWithRules4PreRequest creates a request to invoke UploadAudioDataWithRules4Pre API
func CreateUploadAudioDataWithRules4PreRequest() (request *UploadAudioDataWithRules4PreRequest) {
	request = &UploadAudioDataWithRules4PreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UploadAudioDataWithRules4Pre", "", "")
	return
}

// CreateUploadAudioDataWithRules4PreResponse creates a response to parse from UploadAudioDataWithRules4Pre response
func CreateUploadAudioDataWithRules4PreResponse() (response *UploadAudioDataWithRules4PreResponse) {
	response = &UploadAudioDataWithRules4PreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
