package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadDataWithRules invokes the qualitycheck.UploadDataWithRules API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/uploaddatawithrules.html
func (client *Client) UploadDataWithRules(request *UploadDataWithRulesRequest) (response *UploadDataWithRulesResponse, err error) {
	response = CreateUploadDataWithRulesResponse()
	err = client.DoAction(request, response)
	return
}

// UploadDataWithRulesWithChan invokes the qualitycheck.UploadDataWithRules API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/uploaddatawithrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadDataWithRulesWithChan(request *UploadDataWithRulesRequest) (<-chan *UploadDataWithRulesResponse, <-chan error) {
	responseChan := make(chan *UploadDataWithRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadDataWithRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadDataWithRulesWithCallback invokes the qualitycheck.UploadDataWithRules API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/uploaddatawithrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadDataWithRulesWithCallback(request *UploadDataWithRulesRequest, callback func(response *UploadDataWithRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadDataWithRulesResponse
		var err error
		defer close(result)
		response, err = client.UploadDataWithRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadDataWithRulesRequest is the request struct for api UploadDataWithRules
type UploadDataWithRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// UploadDataWithRulesResponse is the response struct for api UploadDataWithRules
type UploadDataWithRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateUploadDataWithRulesRequest creates a request to invoke UploadDataWithRules API
func CreateUploadDataWithRulesRequest() (request *UploadDataWithRulesRequest) {
	request = &UploadDataWithRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UploadDataWithRules", "", "")
	return
}

// CreateUploadDataWithRulesResponse creates a response to parse from UploadDataWithRules response
func CreateUploadDataWithRulesResponse() (response *UploadDataWithRulesResponse) {
	response = &UploadDataWithRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
